/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jp.ac.naka.ec.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeImpl
implements TreeNode {
    private List<TreeNode> children = new Vector<TreeNode>();
    private TreeNode parent;
    private String name;

    public TreeNodeImpl() {
    }

    public TreeNodeImpl(TreeNode parent) {
        this();
        this.setParent(parent);
    }

    @Override
    public void addChild(TreeNode node) {
        this.children.add(node);
    }

    @Override
    public Set<TreeNode> getChildNodes() {
        HashSet<TreeNode> set = null;
        set = this.children.isEmpty() ? new HashSet<TreeNode>() : new HashSet<TreeNode>(this.children);
        return set;
    }

    @Override
    public String getFullyQualifiedName() {
        String fqfn = "";
        if (this.hasParent()) {
            fqfn = String.valueOf(fqfn) + this.getParent().getFullyQualifiedName() + ".";
        }
        fqfn = String.valueOf(fqfn) + this.getName();
        return fqfn;
    }

    @Override
    public boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public boolean removeChild(TreeNode node) {
        boolean a = false;
        if (this.children.contains(node)) {
            this.children.remove(node);
            a = true;
        }
        return a;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TreeNode node) {
        this.parent = node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this.getFullyQualifiedName() == null) {
            return super.equals(obj);
        }
        if (obj instanceof TreeNode) {
            TreeNode node = (TreeNode)obj;
            boolean a = node.getFullyQualifiedName().equals(this.getFullyQualifiedName());
            return a;
        }
        return false;
    }

    @Override
    public boolean include(TreeNode node) {
        return node.getFullyQualifiedName().indexOf(this.getFullyQualifiedName()) != -1;
    }
}

