/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sip.address.SipURI;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.db.DataObject;
import jp.ac.naka.ec.db.EventData;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.plugin.serial.SensorData;

public class DatabaseConnector {
    public static String driver_name = "org.h2.Driver";
    public static String db_location = "jdbc:h2:tcp://localhost:9092/";
    public static String catalog = "test";
    public static String user = "sa";
    public static String pass = "";
    public static String top_table = "data";
    public static String type_table = "type";
    public static String data_table = "sensor";
    public static String entity_table = "entity";
    public static String location_table = "location";
    private Connection con;
    private Map types;
    private static Logger logger = Logger.getLogger("ECLog");
    private static DatabaseConnector instance = new DatabaseConnector();
    public static int MAX_COLUMN_REQUEST = 100;

    private DatabaseConnector() {
    }

    public static DatabaseConnector getInstance() throws SQLException {
        try {
            DatabaseConnector.initialize();
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.getMessage());
        }
        return instance;
    }

    public static void initialize() throws ClassNotFoundException, SQLException {
        Class.forName(driver_name);
        DatabaseConnector.instance.con = DriverManager.getConnection(String.valueOf(db_location) + catalog, user, pass);
    }

    public boolean hasTables() throws SQLException {
        DatabaseMetaData meta = this.con.getMetaData();
        ResultSet rs = meta.getTables(null, null, null, new String[]{"TABLE"});
        while (rs.next()) {
            String table_name = rs.getString(3);
            if (!table_name.equalsIgnoreCase(top_table)) continue;
            return true;
        }
        return false;
    }

    public boolean createNewTable() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS " + top_table + "(" + "ID INT AUTO_INCREMENT PRIMARY KEY," + "TYPE INT NOT NULL," + "SENSOR_DATA INT," + "OTHER_DATA VARCHAR(255)," + "SOURCE INT," + "TARGET INT," + "LOCATION INT, " + "TIME TIMESTAMP NOT NULL)";
        Statement stmt = this.con.createStatement();
        stmt.execute(query);
        query = "CREATE TABLE IF NOT EXISTS " + data_table + "(" + "ID INT AUTO_INCREMENT PRIMARY KEY," + " TYPE INT NOT NULL," + " VALUE REAL NOT NULL," + "SEQ INT," + "SRC_ADDR INT," + "SRC_PAN_ID INT," + "RSSI INT)";
        stmt.execute(query);
        query = "CREATE TABLE IF NOT EXISTS " + type_table + "(" + "ID INT AUTO_INCREMENT PRIMARY KEY," + "TYPE VARCHAR(20) NOT NULL)";
        stmt.execute(query);
        EntityType[] entityTypeArray = EntityType.values();
        int n = 0;
        int n2 = entityTypeArray.length;
        while (n < n2) {
            EntityType type = entityTypeArray[n];
            query = "INSERT INTO " + type_table + " (TYPE) VALUES " + "('" + type.toString() + "')";
            stmt.execute(query);
            ++n;
        }
        query = "CREATE TABLE IF NOT EXISTS " + entity_table + "(" + "ID INT AUTO_INCREMENT PRIMARY KEY," + "NAME VARCHAR(256) NOT NULL," + "URI VARCHAR (256) NOT NULL," + "TYPE INT NOT NULL," + "USER VARCHAR(256)," + "LOCATION INT)";
        stmt.execute(query);
        query = "CREATE TABLE IF NOT EXISTS " + location_table + "(" + "ID INT AUTO_INCREMENT PRIMARY KEY," + "NAME VARCHAR(256) NOT NULL," + "LATITUDE VARCHAR (256)," + "LONGITUDE VARCHAR (256))";
        stmt.execute(query);
        logger.info(" - Make database tables successfully.");
        return true;
    }

    public int store(EntityType type, SensorData data, Entity source) throws SQLException {
        String query = "";
        int data_num = 0;
        Statement stmt = this.con.createStatement();
        if (data != null) {
            query = "INSERT INTO " + data_table + " (TYPE, VALUE, SEQ, SRC_ADDR, SRC_PAN_ID, RSSI)" + " VALUES (" + type.toString() + ", " + data.getSensorValue() + ", " + data.getSeqNumber() + ", " + data.getSrcAddr() + ", " + data.getSrcPanId() + ", " + data.getRssi() + ")";
            stmt.execute(query);
            query = "SELECT MAX(ID) FROM DATA" + data_table;
            data_num = this.getMaxID(data_table);
        }
        return data_num;
    }

    public boolean store(DataObject data) throws SQLException {
        if (this.con.getAutoCommit()) {
            this.con.setAutoCommit(false);
        }
        this.con.commit();
        try {
            Entity target;
            SensorData sensor = data.getSensorData();
            String query = "";
            int data_num = 0;
            Statement stmt = this.con.createStatement();
            if (sensor != null) {
                data_num = sensor.getId();
            }
            if (this.types == null) {
                this.types = this.getDataTypeTable();
            }
            int target_num = 0;
            Entity source = data.getEventSource();
            int source_num = this.updataEntity(source);
            int type = (Integer)this.types.get((Object)source.getEntityType());
            int location = 0;
            if (data.getLocation() != null) {
                location = this.prepareLocation(data.getLocation());
            }
            if ((target = data.getEventTarget()) != null) {
                target_num = this.updataEntity(target);
            }
            if (data_num != 0) {
                query = "INSERT INTO " + top_table + " (TYPE, SENSOR_DATA, SOURCE, TARGET, LOCATION, TIME) VALUES (" + type + ", " + data_num + ", " + source_num + ", " + target_num + ", " + location + ", CURRENT_TIMESTAMP())";
            } else if (data.getOtherData() != null) {
                query = "INSERT INTO " + top_table + " (TYPE, OTHER_DATA, SOURCE, TARGET, LOCATION, TIME) VALUES (" + type + ", '" + data.getOtherData() + "', " + source_num + ", " + target_num + ", " + location + ", " + "CURRENT_TIMESTAMP())";
            } else {
                throw new SQLException("There is no data.");
            }
            stmt.execute(query);
            this.con.commit();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.con.rollback();
            return false;
        }
        return true;
    }

    private Map getDataTypeTable() throws SQLException {
        HashMap<EntityType, Integer> map = new HashMap<EntityType, Integer>();
        String query = "SELECT * FROM TYPE";
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            Integer num = rs.getInt(1);
            String type = rs.getString(2);
            map.put(EntityType.valueOf(type), num);
        }
        stmt.close();
        return map;
    }

    private int getMaxID(String table) throws SQLException {
        String query = "SELECT MAX(ID) FROM " + table;
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        int data_num = 0;
        if (rs.next()) {
            data_num = rs.getInt(1);
        }
        stmt.close();
        return data_num;
    }

    private int updataEntity(Entity source) throws SQLException {
        int num;
        String query;
        ResultSet rs;
        Statement stmt = this.con.createStatement();
        String user = "";
        int type = (Integer)this.types.get((Object)source.getEntityType());
        if (source.getURI().isSipURI()) {
            SipURI sipuri = source.getURI();
            user = sipuri.getUser();
        }
        if ((rs = stmt.executeQuery(query = "SELECT ID FROM " + entity_table + " WHERE URI='" + source.getURI().toString() + "'")).next()) {
            num = rs.getInt(1);
            if (source.getLocation() != null) {
                int location_num = this.prepareLocation(source.getLocation());
                query = "UPDATE " + entity_table + " SET " + "URI='" + source.getURI().toString() + "', TYPE=" + type + ", USER='" + user + "', LOCATION='" + location_num + "' WHERE ID=" + num;
            } else {
                query = "UPDATE " + entity_table + " SET " + "URI='" + source.getURI().toString() + "', TYPE=" + type + ", USER='" + user + "'  WHERE ID=" + num;
            }
            stmt.execute(query);
        } else {
            query = "INSERT INTO " + entity_table + " (NAME, URI, TYPE, USER) VALUES ('" + source.getFullyQualifiedName() + "', '" + source.getURI().toString() + "', " + type + ", '" + user + "')";
            stmt.execute(query);
            num = this.getMaxID(entity_table);
        }
        stmt.close();
        return num;
    }

    private int prepareLocation(Location location) throws SQLException {
        Statement stmt = this.con.createStatement();
        String query = "SELECT * FROM " + location_table + " WHERE NAME = '" + location.getName() + "'";
        ResultSet rs = stmt.executeQuery(query);
        int num = 0;
        if (rs.next()) {
            num = rs.getInt(1);
            query = "UPDATE " + location_table + " SET LATITUDE='" + location.getLatitude() + "', LONGITUDE='" + location.getLongitude() + "' WHERE ID=" + num;
            stmt.execute(query);
        } else {
            query = "INSERT INTO " + location_table + "(NAME, LATITUDE, LONGITUDE) VALUES ('" + location.getName() + "', '" + location.getLatitude() + "', '" + location.getLongitude() + "')";
            stmt.execute(query);
            query = "SELECT * FROM " + location_table + " WHERE NAME = '" + location.getName() + "'";
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                num = rs.getInt(1);
            }
        }
        return num;
    }

    public EventData[] getData(String uri, int num) throws SQLException {
        String query = "SELECT * FROM ENTITY WHERE URI = '" + uri + "'";
        int id = 0;
        int count = 0;
        int location_num = 0;
        String name = "";
        Location location = null;
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            id = rs.getInt(1);
            name = rs.getString(2);
        }
        query = "SELECT COUNT(*) from " + top_table + " WHERE SOURCE ='" + id + "'";
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            count = rs.getInt(1);
        }
        count = count > MAX_COLUMN_REQUEST ? MAX_COLUMN_REQUEST : count;
        count = count > num ? num : count;
        EventData[] ret = new EventData[count];
        query = "SELECT * from " + top_table + " WHERE SOURCE ='" + id + "' ORDER BY id DESC";
        rs = stmt.executeQuery(query);
        int temp = 0;
        int prev = 0;
        while (rs.next()) {
            String sensor = rs.getString(3);
            location_num = rs.getInt(7);
            if (location_num != 0 && prev != location_num) {
                location = this.getLocation(location_num);
                prev = location_num;
            }
            Timestamp time = rs.getTimestamp(8);
            EventData data = new EventData();
            data.name = name;
            data.date = time.toString();
            if (sensor == null) {
                sensor = rs.getString(4);
            }
            data.value = sensor;
            if (location != null) {
                data.location = location;
            }
            ret[temp++] = data;
            if (temp == count) break;
        }
        return ret;
    }

    private Location getLocation(int num) throws SQLException {
        Statement stmt = this.con.createStatement();
        String query = "SELECT * FROM LOCATION WHERE ID=" + num;
        ResultSet rs2 = stmt.executeQuery(query);
        Location location = null;
        if (rs2.next()) {
            String location_name = rs2.getString(2);
            String latitude = rs2.getString(3);
            String longitude = rs2.getString(4);
            location = new Location(location_name, latitude, longitude);
        }
        return location;
    }
}

