/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import jp.ac.naka.ec.TreeNode;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.sip.SipCore;
import net.sourceforge.jsdp.SessionDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityContainerImpl
extends EntityImpl
implements EntityContainer,
Runnable {
    protected Map<String, EntityListener> table;
    private static Log logger = LogFactory.getLog(EntityContainerImpl.class);
    private TupleSpaceAdapter dispatcher = TupleSpaceAdapter.getInstance();
    public int expires = SipCore.DEFAULT_EXPIRES + 10;
    private boolean running = false;

    public EntityContainerImpl() {
        this.table = new HashMap<String, EntityListener>();
        this.setEntityType(EntityType.CONTAINER);
    }

    public EntityContainerImpl(SipURI uri) {
        this();
        this.setURI(uri);
    }

    public EntityContainerImpl(String name, EntityContainer con) {
        super(con);
        this.setName(name);
        this.table = new HashMap<String, EntityListener>();
        Map temp = con.getEntryTable();
        for (Object key : temp.keySet()) {
            this.table.put((String)key, (EntityListener)temp.get(key));
        }
        this.addEntry((URI)con.getURI(), con);
        EntityEvent evt = new EntityEvent(con, this, EntityEvent.EventType.ADD);
        this.dispatcher.dispatchEvent(evt);
    }

    @Override
    public void addEntity(Entity e) {
        EntityContainerImpl target;
        super.addChild(e);
        this.addEntry((URI)e.getURI(), e);
        EntityContainer entityContainer = target = this.getParent() != null ? (EntityContainer)this.getParent() : this;
        if (target == null) {
            return;
        }
        EntityEvent evt = new EntityEvent(target, e, EntityEvent.EventType.ADD);
        evt.setBroadcast(true);
        this.dispatcher.dispatchEvent(evt);
    }

    @Override
    public EntityContainer getContainer(String uri) {
        if (uri.equals(this.getURI().toString())) {
            return this;
        }
        if (this.hasParent()) {
            EntityContainer con = this.getContainer();
            if (con.getURI().equals(uri)) {
                return con;
            }
        } else {
            Entity e = this.getEntity(uri);
            if (e instanceof EntityContainer) {
                EntityContainer con = (EntityContainer)e;
                return con;
            }
        }
        return null;
    }

    @Override
    public Set<Entity> getEntities() {
        if (this.isLocal()) {
            Set<String> keys = this.table.keySet();
            HashSet<Entity> entities = new HashSet<Entity>();
            for (String key : keys) {
                entities.add((Entity)this.table.get(key));
            }
            return entities;
        }
        Set<TreeNode> nodes = super.getChildNodes();
        HashSet<Entity> entities = new HashSet<Entity>();
        for (TreeNode node : nodes) {
            entities.add((Entity)node);
        }
        return entities;
    }

    @Override
    public Set<Entity> getEntitiesByLocation(String location) {
        return null;
    }

    @Override
    public Entity getEntity(String sip_uri) {
        Entity entity = (Entity)this.table.get(sip_uri);
        return entity;
    }

    @Override
    public void receiveMessage(EntityEvent e) {
        if (!this.isLocal()) {
            return;
        }
        switch (e.getEventType()) {
            case MESSAGE: {
                this.procMessage(e);
                break;
            }
            case INIT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)e.getEventType()) + " is not Supported.");
            }
        }
    }

    @Override
    public void receiveAck(EntityEvent evt) {
    }

    private void procMessage(EntityEvent e) {
        EntityListener target = e.getTarget();
        if (e.isBroadcast() || target.equals(this)) {
            for (TreeNode node : this.getChildNodes()) {
                EntityListener listener = (EntityListener)((Object)node);
                listener.receiveMessage(e);
            }
            return;
        }
        for (TreeNode node : this.getChildNodes()) {
            Entity entity;
            if (!(node instanceof Entity) || !(entity = (Entity)node).equals(target)) continue;
            entity.receiveMessage(e);
        }
    }

    @Override
    public SessionDescription receiveOffer(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        Set<TreeNode> nodes = this.getChildNodes();
        SessionDescription sdp = null;
        Entity entity = null;
        for (TreeNode node : nodes) {
            entity = (Entity)node;
            if (!entity.equals(target)) continue;
            sdp = entity.receiveOffer(e);
            break;
        }
        if (sdp == null) {
            return null;
        }
        Entity source = (Entity)e.getSource();
        EntityEvent evt = new EntityEvent(sdp, (EntityListener)source, entity);
        evt.setEventType(EntityEvent.EventType.ANSWER);
        evt.setRequest(e.getRequest());
        TupleSpaceAdapter dispatcher = TupleSpaceAdapter.getInstance();
        dispatcher.dispatchEvent(evt);
        return null;
    }

    @Override
    public void receiveAnswer(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        Set<TreeNode> nodes = this.getChildNodes();
        for (TreeNode node : nodes) {
            Entity entity = (Entity)node;
            if (!entity.equals(target)) continue;
            entity.receiveAnswer(e);
            break;
        }
    }

    @Override
    public void receiveBye(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        Set<TreeNode> nodes = this.getChildNodes();
        Entity entity = null;
        for (TreeNode node : nodes) {
            entity = (Entity)node;
            if (!entity.equals(target)) continue;
            entity.receiveBye(e);
            break;
        }
    }

    @Override
    public void addedNewEntity(EntityEvent evt) {
        if (evt.getSource().equals(this)) {
            return;
        }
        switch (evt.getEventType()) {
            case REGISTER: {
                EntityContainer e = (EntityContainer)evt.getSource();
                if (this.include(e)) {
                    Set<String> set = this.table.keySet();
                    ArrayList<Entity> removeNodes = new ArrayList<Entity>();
                    SipURI parent_uri = e.getURI();
                    for (String str : set) {
                        Entity node = (Entity)this.table.get(str);
                        SipURI uri = node.getURI();
                        if (!uri.getHost().equals(parent_uri.getHost()) || uri.getPort() != parent_uri.getPort()) continue;
                        removeNodes.add(node);
                    }
                    EntityEvent ee = new EntityEvent(e);
                    ee.setEventType(EntityEvent.EventType.REMOVE);
                    this.informToEntities(ee);
                    for (Entity node : removeNodes) {
                        logger.info((Object)("Remove Entity:" + node.getURI()));
                        this.table.remove(node.getURI().toString());
                        node = null;
                    }
                    logger.info((Object)("Remove EntityContainer:" + parent_uri));
                    this.table.remove(parent_uri.toString());
                }
                logger.info((Object)("Add External EntityContainer :" + e.getURI()));
                this.addEntry((URI)e.getURI(), e);
                break;
            }
            case ADD: {
                if (evt.getSource() instanceof Entity) {
                    Entity source = (Entity)evt.getSource();
                    this.addEntry((URI)source.getURI(), source);
                    logger.info((Object)("Add Entity :" + source.getURI()));
                    this.informToEntities(evt);
                    break;
                }
            }
            case SUBSCRIBE: 
            case NOTIFY: {
                Entity[] entities = (Entity[])evt.getSource();
                ArrayList<Entity> removed = new ArrayList<Entity>();
                Entity[] entityArray = entities;
                int ee = 0;
                int n = entityArray.length;
                while (ee < n) {
                    Entity entity = entityArray[ee];
                    if (!this.table.containsKey(entity.getURI().toString()) && !entity.equals(this) && entity.isAlive()) {
                        this.addEntry((URI)entity.getURI(), entity);
                        logger.info((Object)("Add External Entity :" + entity.getURI()));
                        this.informToEntities(evt);
                    } else if (this.table.containsKey(entity.getURI().toString()) && !entity.isAlive()) {
                        removed.add(entity);
                        logger.info((Object)("Remove Entity:" + entity.getURI()));
                        this.table.remove(entity.getURI().toString());
                    }
                    ++ee;
                }
                if (removed.size() == 0) break;
                Entity[] temp2 = new Entity[removed.size()];
                EntityEvent evt2 = new EntityEvent(removed.toArray(temp2));
                evt.setEventType(EntityEvent.EventType.REMOVE);
                this.informToEntities(evt2);
            }
        }
    }

    @Override
    public void removedEntity(EntityEvent evt) {
        SipURI parent_uri;
        if (evt.getSource() instanceof EntityContainer) {
            EntityContainer con = (EntityContainer)evt.getSource();
            Set<String> set = this.table.keySet();
            ArrayList<Entity> removeNodes = new ArrayList<Entity>();
            parent_uri = con.getURI();
            for (String str : set) {
                Entity node = (Entity)this.table.get(str);
                SipURI uri = node.getURI();
                if (!uri.getHost().equals(parent_uri.getHost()) || uri.getPort() != parent_uri.getPort()) continue;
                removeNodes.add(node);
                con.addChild(node);
            }
            EntityEvent ee = new EntityEvent(con);
            ee.setEventType(EntityEvent.EventType.REMOVE);
            this.informToEntities(ee);
            for (Entity node : removeNodes) {
                logger.info((Object)("Remove Entity:" + node.getURI()));
                this.table.remove(node.getURI().toString());
            }
        } else {
            throw new UnsupportedOperationException("Not implemented");
        }
        logger.info((Object)("Remove EntityContainer:" + parent_uri));
        this.table.remove(parent_uri.toString());
    }

    private void informToEntities(EntityEvent evt) {
        for (TreeNode child : this.getChildNodes()) {
            Entity entity = (Entity)child;
            switch (evt.getEventType()) {
                case ADD: 
                case SUBSCRIBE: 
                case NOTIFY: {
                    entity.addedNewEntity(evt);
                    break;
                }
                case REMOVE: {
                    entity.removedEntity(evt);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid Operation :" + (Object)((Object)evt.getEventType()));
                }
            }
        }
    }

    private void addEntry(URI uri, EntityListener listener) {
        this.table.put(uri.toString(), listener);
    }

    private boolean removeEntry(String name) {
        return this.table.remove(name) != null;
    }

    @Override
    public Map getEntryTable() {
        return this.table;
    }

    @Override
    public void setParent(TreeNode node) {
        if (this.getParent() == null) {
            super.setParent(node);
            if (!this.isLocal()) {
                return;
            }
            EntityEvent evt = new EntityEvent((EntityListener)((Object)node), this, EntityEvent.EventType.INIT);
            this.dispatcher.dispatchEvent(evt);
        } else {
            Entity entity = (Entity)node;
            this.addEntry((URI)entity.getURI(), entity);
            super.setParent(node);
        }
    }

    @Override
    public boolean removeChild(TreeNode node) {
        if (node instanceof EntityContainer) {
            EntityContainer con = (EntityContainer)node;
            Set<Entity> entities = con.getEntities();
            for (Entity entity : entities) {
                this.removeEntry(entity.getURI().toString());
                con.removeChild(entity);
                entity = null;
            }
            this.removeEntry(con.getURI().toString());
            con = null;
        } else {
            Entity entity = (Entity)node;
            this.removeEntry(entity.getURI().toString());
            Object var2_3 = null;
        }
        return true;
    }

    @Override
    public boolean include(TreeNode node) {
        Entity e = (Entity)node;
        return this.table.containsKey(e.getURI().toString());
    }

    @Override
    public void run() {
        this.alive = true;
        this.running = true;
        while (this.alive) {
            this.alive = false;
            try {
                Thread.sleep(this.expires * 1000);
            }
            catch (InterruptedException e) {
                logger.info((Object)("Interrupt :" + this.getURI()));
                break;
            }
        }
        this.running = false;
        logger.info((Object)("Expires out :" + this.getURI()));
        EntityEvent evt = new EntityEvent(this);
        evt.setEventType(EntityEvent.EventType.REMOVE);
        this.dispatcher.dispatchEvent(evt);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void refresh() {
        this.alive = true;
    }
}

