/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.util.EventObject;
import javax.sip.address.SipURI;
import javax.sip.message.Request;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityListener;
import net.sourceforge.jsdp.SessionDescription;

public class EntityEvent
extends EventObject {
    private static final long serialVersionUID = -5024101656766992758L;
    private EntityListener target;
    private String message;
    private SessionDescription sdp;
    private Request request;
    private EventType type;
    private boolean broadcast = false;
    private SipURI from;

    public EntityEvent(EntityContainer source) {
        super(source);
        this.type = EventType.REGISTER;
    }

    public EntityEvent(Entity[] entities) {
        super(entities);
        this.type = EventType.NOTIFY;
    }

    public EntityEvent(EntityListener target, Entity source, EventType type) {
        this("", target, source, type);
    }

    public EntityEvent(String message, EntityListener target, Entity source, EventType type) {
        super(source);
        this.message = message;
        this.target = target;
        this.type = type;
    }

    public EntityEvent(String message, EntityListener target, Entity source) {
        super(source);
        this.message = message;
        this.target = target;
        if (target == null) {
            this.broadcast = true;
        }
        this.type = EventType.MESSAGE;
    }

    public EntityEvent(SessionDescription sdp, EntityListener target, Entity source) {
        this("", target, source);
        this.type = EventType.OFFER;
        this.sdp = sdp;
    }

    public EntityListener getTarget() {
        return this.target;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SessionDescription getSessionDescription() {
        return this.sdp;
    }

    public EventType getEventType() {
        return this.type;
    }

    public void setEventType(EventType type) {
        this.type = type;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request req) {
        this.request = req;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public String toString() {
        return "Target :" + this.target + ", Type :" + this.type.toString();
    }

    public void setFrom(SipURI fromUri) {
        this.from = fromUri;
    }

    public SipURI getFrom() {
        return this.from;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        MESSAGE,
        LOCATION,
        INIT,
        REGISTER,
        OFFER,
        ADD,
        ANSWER,
        IMAGE,
        BYE,
        SUBSCRIBE,
        NOTIFY,
        ACK,
        REMOVE;

    }
}

