/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.plugin.http;

import java.util.Properties;
import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.plugin.http.AjaxHandler;
import jp.ac.naka.ec.plugin.http.HttpHandlerExt;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;

public class HttpCore
extends EventSource {
    HttpServer server;
    public static int DEFAULT_PORT = 8080;

    public void init(EntityContainer source) throws Exception {
        int port = DEFAULT_PORT;
        String base = "./html";
        this.server = new HttpServer();
        SocketListener listener = new SocketListener();
        listener.setPort(port);
        this.server.addListener((HttpListener)listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        AjaxHandler handler = new AjaxHandler();
        handler.setSourceEntity(source);
        context.addHandler((HttpHandler)handler);
        context.setResourceBase(base);
        context.addHandler((HttpHandler)new ResourceHandler());
        this.server.addContext(context);
        this.server.start();
    }

    public void init(EntityContainer source, Properties prop) throws Exception {
        String t = prop.getProperty("port");
        int port = DEFAULT_PORT;
        if (t != null && !t.equals("")) {
            port = Integer.parseInt(t);
        }
        String base = "./html";
        t = prop.getProperty("resourceBase");
        if (t != null && !t.equals("")) {
            base = t;
        }
        this.server = new HttpServer();
        SocketListener listener = new SocketListener();
        listener.setPort(port);
        this.server.addListener((HttpListener)listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        context.setResourceBase(base);
        t = prop.getProperty("handler");
        if (t != null && !t.equals("")) {
            Class<?> clz = Class.forName(t);
            HttpHandlerExt handler = (HttpHandlerExt)clz.newInstance();
            handler.setSourceEntity(source);
            context.addHandler((HttpHandler)handler);
        }
        context.addHandler((HttpHandler)new ResourceHandler());
        this.server.addContext(context);
        this.server.start();
    }

    public boolean isStarted() {
        if (this.server == null) {
            return false;
        }
        return this.server.isStarted();
    }

    public void stopServer() throws InterruptedException {
        this.server.stop();
    }
}

