/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.plugin.mail;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.exif.GpsDirectory;
import com.sun.mail.pop3.POP3SSLStore;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.plugin.mail.MailBodyParser;
import jp.ac.naka.ec.plugin.mail.MailBodyParserImpl;
import org.apache.log4j.Logger;

public class GMailReceiver
extends EventSource {
    private static Logger logger = Logger.getLogger(GMailReceiver.class);
    private String user;
    private String pass;
    private String pop3 = "";
    EntityContainer source;
    private Session session;
    private Store store;
    private Folder folder;
    private MailBodyParser parser = null;
    private EntityListener target;
    public static String resource_folder = "photo";
    public static int INTERVAL = 30000;

    public void init(EntityContainer source) throws Exception {
        this.source = source;
        this.pop3 = "pop.gmail.com";
        this.user = "fugameister@gmail.com";
        this.pass = "vitaminwater";
        this.connect();
        Timer timer = new Timer(true);
        GetMailTask task = new GetMailTask();
        timer.schedule((TimerTask)task, 0L, (long)INTERVAL);
    }

    public void init(EntityContainer source, Properties prop) throws Exception {
        this.source = source;
        this.pop3 = prop.getProperty("pop");
        this.user = prop.getProperty("user");
        this.pass = prop.getProperty("password");
        String temp = prop.getProperty("interval");
        if (temp != null && !temp.equals("")) {
            INTERVAL = Integer.valueOf(temp);
        }
        if ((temp = prop.getProperty("parser")) != null && !temp.equals("")) {
            Class<?> clazz = Class.forName(temp);
            this.parser = (MailBodyParser)clazz.newInstance();
        }
        this.connect();
        Timer timer = new Timer(true);
        GetMailTask task = new GetMailTask();
        timer.schedule((TimerTask)task, 0L, (long)INTERVAL);
    }

    private void connect() throws MessagingException {
        String host;
        Properties pop3Props = new Properties();
        pop3Props.setProperty("mail.pop3.user", this.user);
        pop3Props.setProperty("mail.pop3.passwd", this.pass);
        pop3Props.setProperty("mail.pop3.ssl", "true");
        pop3Props.setProperty("mail.pop3.host", this.pop3);
        String user = pop3Props.getProperty("mail.pop3.user") != null ? pop3Props.getProperty("mail.pop3.user") : pop3Props.getProperty("mail.user");
        String passwd = pop3Props.getProperty("mail.pop3.passwd") != null ? pop3Props.getProperty("mail.pop3.passwd") : pop3Props.getProperty("mail.passwd");
        String string = host = pop3Props.getProperty("mail.pop3.host") != null ? pop3Props.getProperty("mail.pop3.host") : pop3Props.getProperty("mail.host");
        if (pop3Props.getProperty("mail.pop3.ssl") != null && pop3Props.getProperty("mail.pop3.ssl").equalsIgnoreCase("true")) {
            String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
            pop3Props.setProperty("mail.pop3.socketFactory.class", SSL_FACTORY);
            pop3Props.setProperty("mail.pop3.socketFactory.fallback", "false");
            String portStr = pop3Props.getProperty("mail.pop3.port") != null ? pop3Props.getProperty("mail.pop3.port") : "995";
            pop3Props.setProperty("mail.pop3.port", portStr);
            pop3Props.setProperty("mail.pop3.socketFactory.port", portStr);
            URLName url = new URLName("pop3://" + user + ":" + passwd + "@" + host + ":" + pop3Props.getProperty("mail.pop3.port"));
            this.session = Session.getInstance((Properties)pop3Props, null);
            this.store = new POP3SSLStore(this.session, url);
        } else {
            this.session = Session.getInstance((Properties)pop3Props, null);
            this.store = this.session.getStore("pop3");
        }
        this.store.connect(host, user, passwd);
    }

    public void openFolder(String folderName) throws MessagingException {
        this.folder = this.store.getDefaultFolder();
        this.folder = this.folder.getFolder(folderName);
        if (this.folder == null) {
            throw new NullPointerException("Invalid folder");
        }
        this.folder.open(1);
    }

    public void closeFolder() throws Exception {
        this.folder.close(false);
    }

    public void disconnect() throws Exception {
        this.store.close();
    }

    public void processMessage(Message p) throws Exception {
        String message = null;
        String filename = "";
        GPSInfo info = null;
        if (this.parser == null) {
            this.parser = new MailBodyParserImpl();
        }
        message = this.parser.parseMailBody(p);
        String subject = p.getSubject();
        StringBuilder sb = new StringBuilder(message);
        if (p.isMimeType("text/plain")) {
            sb.append("<content><![CDATA[");
            sb.append((String)p.getContent());
            sb.append("]]></content>");
        } else if (p.isMimeType("multipart/alternative")) {
            MimeMultipart mmp = (MimeMultipart)p.getContent();
            int i = 0;
            while (i < mmp.getCount()) {
                BodyPart part = mmp.getBodyPart(i);
                if (part.isMimeType("text/plain")) {
                    sb.append("<content><![CDATA[");
                    sb.append((String)part.getContent());
                    sb.append("]]></content>");
                }
                ++i;
            }
        } else if (p.isMimeType("Multipart/Mixed")) {
            Multipart multipart = (Multipart)p.getContent();
            if (multipart == null) {
                throw new NullPointerException("Constent is null");
            }
            int i = 0;
            while (i < multipart.getCount()) {
                MimeBodyPart mbp;
                BodyPart part = multipart.getBodyPart(i);
                String disp = part.getDisposition();
                if (disp == null) {
                    mbp = (MimeBodyPart)part;
                    if (part.isMimeType("text/plain")) {
                        sb.append("<content><![CDATA[");
                        sb.append((String)mbp.getContent());
                        sb.append("]]></content>");
                    } else if (part.isMimeType("multipart/alternative")) {
                        sb.append("<content><![CDATA[");
                        sb.append("UNREAD");
                        sb.append("]]></content>");
                    }
                } else if ((disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline")) && (mbp = (MimeBodyPart)part).isMimeType("image/jpeg")) {
                    filename = String.valueOf(System.currentTimeMillis()) + ".jpg";
                    try {
                        BufferedImage image = ImageIO.read(part.getInputStream());
                        filename = this.saveImageFile(filename, image);
                        filename = filename.replace("\\", "/");
                        info = this.getGPSInfoFromExif(part.getInputStream());
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Error while processing attachment file.", (Throwable)e);
                    }
                }
                ++i;
            }
        }
        message = sb.toString();
        sb = new StringBuilder();
        sb.append("<mail>");
        sb.append(message);
        sb.append("<subject>");
        sb.append(subject);
        sb.append("</subject>");
        if (info != null) {
            sb.append("<latitude>");
            sb.append(info.getLatitude());
            sb.append("</latitude>");
            sb.append("<longitude>");
            sb.append(info.getLongitude());
            sb.append("</longitude>");
            sb.append("<path>");
            sb.append(filename);
            sb.append("</path>");
        }
        sb.append("</mail>");
        EntityEvent evt = new EntityEvent(sb.toString(), this.target, (Entity)this.source);
        this.getEventDispatcher().dispatchEvent(evt);
    }

    GPSInfo getGPSInfoFromExif(InputStream input) throws MetadataException {
        Metadata metadata = null;
        try {
            metadata = new ExifReader(input).extract();
        }
        catch (JpegProcessingException e) {
            e.printStackTrace();
        }
        Directory exifDirectory = metadata.getDirectory(ExifDirectory.class);
        Date date = null;
        if (exifDirectory.containsTag(36867)) {
            date = exifDirectory.getDate(36867);
        }
        Directory gpsDirectory = metadata.getDirectory(GpsDirectory.class);
        String datum = gpsDirectory.getString(18);
        float lat = 0.0f;
        float lon = 0.0f;
        if (datum == null) {
            return null;
        }
        if (!datum.equals("WGS-84")) {
            throw new UnsupportedOperationException("\u65e5\u672c\u6e2c\u5730\u7cfb\u306f\u672a\u5bfe\u5fdc");
        }
        lat = GMailReceiver.toGeocode(gpsDirectory.getRationalArray(2));
        lon = GMailReceiver.toGeocode(gpsDirectory.getRationalArray(4));
        return new GPSInfo(date, lat, lon);
    }

    static float toGeocode(Rational[] rationals) {
        float ret = 0.0f;
        int i = 0;
        Rational[] rationalArray = rationals;
        int n = 0;
        int n2 = rationalArray.length;
        while (n < n2) {
            Rational r = rationalArray[n];
            switch (i++) {
                case 0: {
                    ret += r.floatValue();
                    break;
                }
                case 1: {
                    ret += r.floatValue() / 60.0f;
                    break;
                }
                case 2: {
                    ret += r.floatValue() / 3600.0f;
                }
            }
            ++n;
        }
        return ret;
    }

    private String saveImageFile(String filename, BufferedImage image) throws IOException {
        File dir = new File(resource_folder);
        if (!dir.exists()) {
            dir.mkdir();
        }
        File f = new File(dir.getAbsoluteFile() + "/" + filename);
        ImageIO.write((RenderedImage)image, "jpg", f);
        return f.getAbsolutePath();
    }

    float toGeocode(String src) {
        float ret = 0.0f;
        if (src == null) {
            return 0.0f;
        }
        String temp = src.replace('\"', '.');
        temp = temp.replace('\'', '.');
        String[] values = temp.split("\\.");
        ret = Float.valueOf(values[0]).floatValue();
        ret += 0.016666668f * Float.valueOf(values[1]).floatValue();
        return ret += 2.7777778E-4f * Float.valueOf(String.valueOf(values[2]) + "." + values[3]).floatValue();
    }

    public static void main(String[] args) throws Exception {
        new Main();
    }

    public void setTarget(EntityListener target) {
        this.target = target;
    }

    private static class GPSInfo {
        private float latitude;
        private float longitude;
        private Date date;

        public GPSInfo(Date date, float lat, float lon) {
            this.date = date;
            this.latitude = lat;
            this.longitude = lon;
        }

        public float getLatitude() {
            return this.latitude;
        }

        public float getLongitude() {
            return this.longitude;
        }
    }

    private class GetMailTask
    extends TimerTask {
        private GetMailTask() {
        }

        public void run() {
            try {
                GMailReceiver.this.openFolder("INBOX");
                Message[] msgs = GMailReceiver.this.folder.getMessages();
                FetchProfile fp = new FetchProfile();
                fp.add(FetchProfile.Item.ENVELOPE);
                GMailReceiver.this.folder.fetch(msgs, fp);
                int i = 0;
                while (i < msgs.length) {
                    logger.info((Object)("Get message from [" + msgs[i].getFrom()[0] + "]"));
                    GMailReceiver.this.processMessage(msgs[i]);
                    ++i;
                }
                if (msgs.length == 0) {
                    logger.info((Object)"No mail");
                }
                GMailReceiver.this.closeFolder();
            }
            catch (Exception e) {
                logger.error((Object)"Error occure while getting Email", (Throwable)e);
                try {
                    GMailReceiver.this.closeFolder();
                    GMailReceiver.this.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

