/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.plugin.mail;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import jp.ac.naka.ec.plugin.mail.MailBodyParser;

public class MailBodyParserImpl
implements MailBodyParser {
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");

    public String parseMailBody(Message message) {
        StringBuilder sb = new StringBuilder();
        Address[] addr = null;
        try {
            addr = message.getFrom();
            if (addr != null) {
                int j = 0;
                while (j < addr.length) {
                    sb.append("<from><![CDATA[");
                    sb.append(addr[j]);
                    sb.append("]]></from>");
                    ++j;
                }
            }
        }
        catch (MessagingException j) {
            // empty catch block
        }
        try {
            addr = message.getRecipients(Message.RecipientType.TO);
            if (addr != null) {
                int j = 0;
                while (j < addr.length) {
                    sb.append("<to>");
                    sb.append(addr[j].toString());
                    sb.append("</to>");
                    ++j;
                }
            }
        }
        catch (MessagingException j) {
            // empty catch block
        }
        try {
            sb.append("<subject>");
            sb.append(message.getSubject());
            sb.append("</subject>");
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        try {
            Date d = message.getSentDate();
            if (d != null) {
                sb.append("<date>");
                sb.append(this.formatter.format(d));
                sb.append("</date>");
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return sb.toString();
    }
}

