/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.plugin.serial;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.db.DatabaseConnector;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.plugin.serial.DefaultParser;
import jp.ac.naka.ec.plugin.serial.SerialInputParser;
import org.apache.log4j.Logger;

public class SerialManager
extends EventSource
implements SerialPortEventListener {
    private static DatabaseConnector con;
    private static Logger logger;
    private Entity source;
    private SerialInputParser parser;
    public static String commPort;
    private int baud_rate = 9600;
    private final int timeout = 20000;
    private OutputStream out;
    private BufferedReader comReader;

    static {
        logger = Logger.getLogger(SerialManager.class);
        commPort = "COM1";
    }

    public void init(EntityContainer source) throws Exception {
        this.source = source;
        this.parser = new DefaultParser();
        this.initialize();
    }

    public void init(EntityContainer source, Properties prop) throws Exception {
        String a;
        String baud;
        String port;
        this.source = source;
        if (Main.con != null) {
            con = Main.con;
        }
        if ((port = prop.getProperty("port")) != null && !port.equals("")) {
            commPort = port;
        }
        if ((baud = prop.getProperty("baudRate")) != null && !baud.equals("")) {
            this.baud_rate = Integer.valueOf(baud);
        }
        if ((a = prop.getProperty("SerialInputParser")) != null && !a.equals("")) {
            try {
                Class<?> clz = Class.forName(a);
                this.parser = (SerialInputParser)clz.newInstance();
            }
            catch (Exception e) {
                logger.warn((Object)("Invalid SerialInputParser Class :" + a), (Throwable)e);
            }
        }
        if (this.parser == null) {
            this.parser = new DefaultParser();
        }
        this.initialize();
    }

    public void initialize() throws IOException {
        try {
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)commPort);
            if (portIdentifier.isCurrentlyOwned()) {
                logger.error((Object)"Error: Port is currently in use");
            } else {
                CommPort commPort = portIdentifier.open(this.getClass().getName(), 20000);
                if (commPort instanceof SerialPort) {
                    SerialPort serialPort = (SerialPort)commPort;
                    serialPort.setSerialPortParams(this.baud_rate, 8, 1, 0);
                    serialPort.addEventListener((SerialPortEventListener)this);
                    serialPort.notifyOnDataAvailable(true);
                    InputStream in = serialPort.getInputStream();
                    this.out = serialPort.getOutputStream();
                    this.comReader = new BufferedReader(new InputStreamReader(in));
                } else {
                    logger.error((Object)"Error: Only serial ports are handled by this example.");
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                String buffer = null;
                try {
                    while (this.comReader.ready()) {
                        buffer = this.comReader.readLine();
                        EntityEvent evt = this.parser.parse(buffer, this.source);
                        if (evt == null) continue;
                        this.getEventDispatcher().dispatchEvent(evt);
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void receiveMessage(EntityEvent evt) {
        String str = evt.getMessage();
        if (str != null) {
            byte[] bytes = str.getBytes();
            try {
                this.out.write(bytes, 0, bytes.length);
            }
            catch (IOException e) {
                logger.error((Object)"Error while input message to serial", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            SerialManager sc = new SerialManager();
            sc.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSeialInputParser(SerialInputParser parser2) {
        this.parser = parser2;
    }
}

