/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.plugin.xmlrpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

public class BlogPoster
extends EventSource {
    String url = "http://ibaraki.iobb.net/mt/mt-xmlrpc.cgi";
    String methodName = "metaWeblog.newPost";
    String blogid = "7";
    String username = "kasuya";
    String password = "elecom30";
    Integer publish = new Integer(1);
    Vector params = new Vector();
    Entity source;
    List<EntityListener> targets = new ArrayList<EntityListener>();

    public BlogPoster() {
        XmlRpc.setEncoding((String)"UTF-8");
    }

    public void init(EntityContainer source) throws Exception {
    }

    public void init(EntityContainer source, Properties prop) throws Exception {
    }

    public void receiveMessage(EntityEvent evt) {
        if (evt.getTarget() != null && !evt.getTarget().equals(this)) {
            return;
        }
        String str = evt.getMessage();
        if (str == null) {
            return;
        }
        Mail mail = null;
        try {
            mail = this.getMail(str);
        }
        catch (Exception e) {
            return;
        }
        Hashtable<String, String> content = new Hashtable<String, String>();
        content.put("title", mail.subject);
        content.put("description", mail.content);
        Vector<Object> params = new Vector<Object>();
        params.add(this.blogid);
        params.add(this.username);
        params.add(this.password);
        params.add(content);
        params.add(this.publish);
        try {
            XmlRpcClientLite client = new XmlRpcClientLite(this.url);
            Object result = client.execute(this.methodName, params);
            mail.entryId = Integer.parseInt(result.toString());
            if (this.source == null) {
                this.source = new EntityImpl(this.getURI());
            }
            for (EntityListener target : this.targets) {
                EntityEvent e = new EntityEvent(mail.toString(), target, this.source);
                this.dispatcher.dispatchEvent(e);
            }
        }
        catch (XmlRpcException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        params.remove(content);
    }

    public String getBlogId() {
        return this.blogid;
    }

    public void setBlogId(String blogid) {
        this.blogid = blogid;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPublish() {
        return this.publish;
    }

    public void setPublish(Integer publish) {
        this.publish = publish;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    private Mail getMail(String message) {
        Mail mail = new Mail();
        int index = message.indexOf("<path>");
        int endIndex = message.indexOf("</path>");
        String path = message.substring(index + "<path>".length(), endIndex);
        index = message.indexOf("<subject>");
        endIndex = message.indexOf("</subject>");
        String subject = message.substring(index + "<subject>".length(), endIndex);
        index = message.indexOf("<content><![CDATA[");
        endIndex = message.indexOf("]]></content>");
        String content = message.substring(index + "<content><![CDATA[".length(), endIndex);
        index = message.indexOf("<latitude>");
        endIndex = message.indexOf("</latitude>");
        String lat = message.substring(index + "<latitude>".length(), endIndex);
        index = message.indexOf("<longitude>");
        endIndex = message.indexOf("</longitude>");
        String lon = message.substring(index + "<longitude>".length(), endIndex);
        index = message.indexOf("<date>");
        endIndex = message.indexOf("</date>");
        String date = message.substring(index + "<date>".length(), endIndex);
        mail.content = content;
        mail.subject = subject;
        mail.latitude = lat;
        mail.longitude = lon;
        mail.path = path;
        mail.date = date;
        return mail;
    }

    public static void main(String[] args) {
        BlogPoster blog = new BlogPoster();
        EntityEvent evt = new EntityEvent("<mail><path>hoge</path><content>\u307b\u3052</content><latitude>100</latitude><longitude>100</longitude></mail>", (EntityListener)blog, (Entity)new EntityImpl());
        blog.receiveMessage(evt);
    }

    public void addTarget(EntityListener target) {
        this.targets.add(target);
    }

    class Mail {
        String subject;
        String content;
        String path;
        String latitude;
        String longitude;
        String date;
        int entryId;

        Mail() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<mail>");
            sb.append(this.addTab("subject", this.subject));
            sb.append(this.addTab("content", this.content));
            sb.append(this.addTab("path", this.path));
            sb.append(this.addTab("latitude", this.latitude));
            sb.append(this.addTab("longitude", this.longitude));
            sb.append(this.addTab("date", this.date));
            sb.append(this.addTab("id", String.valueOf(this.entryId)));
            sb.append("</mail>");
            return sb.toString();
        }

        public String addTab(String name, String content) {
            return "<" + name + ">" + content + "</" + name + ">";
        }
    }
}

