/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.message.Request;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.PIDFParser;
import jp.ac.naka.ec.sip.pidf.PIDFParserImpl;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.SAXException;

class NotifyDelegate
extends MethodDelegate {
    private static Logger logger = Logger.getLogger(NotifyDelegate.class);
    private PIDFParser parser = PIDFParserImpl.getInatance();

    public NotifyDelegate() throws ParserConfigurationException, SAXException {
        PropertyConfigurator.configure((String)Main.log4j_properties);
        this.dispatcher = TupleSpaceAdapter.getInstance();
        this.core = SipCore.getInstance();
    }

    public boolean forward(RequestEvent evt) {
        Address addr;
        FromHeader from;
        byte[] content;
        block4: {
            Request req = evt.getRequest();
            content = req.getRawContent();
            try {
                from = (FromHeader)req.getHeader("From");
                addr = from.getAddress();
                if (content != null) break block4;
                this.core.sendResponse(200, evt, addr.getURI().toString());
                return false;
            }
            catch (Exception e) {
                logger.warn((Object)"Error occures while processing PIDF :", (Throwable)e);
                return false;
            }
        }
        PIDFData data = this.parser.parse(content);
        Entity[] entities = this.makeEntitiesFromPIDF(data);
        if (entities != null) {
            SipURI fromUri = (SipURI)from.getAddress().getURI();
            EntityEvent ee = new EntityEvent(entities);
            ee.setFrom(fromUri);
            ee.setMessage(new String(content, "UTF-8"));
            ee.setEventType(EntityEvent.EventType.NOTIFY);
            this.dispatcher.dispatchEvent(ee);
        }
        this.core.sendResponse(200, evt, addr.getURI().toString());
        return true;
    }
}

