/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import gov.nist.javax.sip.address.SipUri;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import jp.ac.naka.ec.TreeNode;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.sip.DefaultListener;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.PIDFFactory;
import jp.ac.naka.ec.sip.pidf.PIDFFactoryImpl;
import net.sourceforge.jsdp.SessionDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SipCore {
    private SipProvider provider;
    private SipListener sip_listener;
    private MessageFactory messageFactory;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private SipURI uri;
    private boolean initialized = false;
    private EntityContainer con;
    private static SipCore instance = new SipCore();
    public static int DEFAULT_EXPIRES = 60;
    public static String event_package = "presence";
    private static Map<String, Dialog> dialogTable = new HashMap<String, Dialog>();
    private static final String pathname = "gov.nist";
    public static String TRANSPORT = "udp";
    private static Log logger = LogFactory.getLog(SipCore.class);
    private PIDFFactory pidfFactory;
    private EntityListener listener = new EntityEventListener();
    Random rand = new Random();
    NotifyTask task;

    public void initialize(String name, String hostname, int sip_port, String sip_config) throws SipException, IOException, ParseException, InvalidArgumentException, TooManyListenersException {
        if (this.provider != null) {
            return;
        }
        SipFactory sipFactory = SipFactory.getInstance();
        sipFactory.setPathName(pathname);
        Properties prop = new Properties();
        prop.load(new FileInputStream(sip_config));
        SipStack sipStack = null;
        sipStack = sipFactory.createSipStack(prop);
        this.addressFactory = sipFactory.createAddressFactory();
        this.uri = this.addressFactory.createSipURI(name, String.valueOf(hostname) + ":" + sip_port);
        logger.info((Object)("getHostAddress:\t" + this.uri.toString()));
        ListeningPoint lp = sipStack.createListeningPoint(hostname, sip_port, TRANSPORT);
        this.provider = sipStack.createSipProvider(lp);
        this.sip_listener = new DefaultListener();
        this.provider.addSipListener(this.sip_listener);
        this.messageFactory = sipFactory.createMessageFactory();
        this.headerFactory = sipFactory.createHeaderFactory();
        EntityEventDispatcher dispatcher = EntityEventDispatcher.getInstance();
        dispatcher.addEntityListener(this.listener);
        this.initialized = true;
    }

    public void initialize(String sip_config) throws IOException, SipException, ParseException, InvalidArgumentException, TooManyListenersException {
        String hostname = this.getHostName();
        String ipAddr = this.getIpAddress(hostname);
        int port = 5060;
        this.initialize(hostname, ipAddr, port, sip_config);
    }

    public void initialize(int port, String sip_config) throws IOException, SipException, ParseException, InvalidArgumentException, TooManyListenersException {
        String hostname = this.getHostName();
        String ipAddr = this.getIpAddress(hostname);
        this.initialize(hostname, ipAddr, port, sip_config);
    }

    public static SipCore getInstance() {
        return instance;
    }

    public void setEntityContainer(EntityContainer container) {
        this.con = container;
        this.uri = this.con.getURI();
        this.pidfFactory = new PIDFFactoryImpl(this.con);
    }

    public void sendResponse(int num, Request req) throws ParseException, InvalidArgumentException, SipException {
        Response res = this.messageFactory.createResponse(num, req);
        FromHeader from = (FromHeader)res.getHeader("From");
        logger.info((Object)("Sending Response (" + num + ") to " + from.getAddress()));
        this.provider.sendResponse(res);
    }

    public void sendResponse(int num, RequestEvent evt, String sender_uri) throws ParseException, SipException, InvalidArgumentException {
        ServerTransaction st;
        if (!this.initialized) {
            return;
        }
        Request req = evt.getRequest();
        Response res = this.messageFactory.createResponse(num, req);
        if (req.getMethod().equals("SUBSCRIBE")) {
            this.prepareResponse(res);
            ExpiresHeader expiresHeader = req.getExpires();
            int expires = expiresHeader.getExpires() - 1;
            res.setHeader((Header)this.headerFactory.createExpiresHeader(expires));
        }
        if ((st = evt.getServerTransaction()) == null) {
            st = this.provider.getNewServerTransaction(req);
        }
        logger.info((Object)("Sending " + req.getMethod() + " Response to " + sender_uri));
        st.sendResponse(res);
        if (req.getMethod().equals("SUBSCRIBE") || req.getMethod().equals("NOTIFY")) {
            Dialog dialog = st.getDialog();
            dialogTable.put(sender_uri, dialog);
        } else if (num == 100) {
            Dialog dialog = st.getDialog();
            dialogTable.put(sender_uri, dialog);
            dialog.setApplicationData((Object)st);
        }
    }

    private void prepareResponse(Response res) throws ParseException, InvalidArgumentException {
        ToHeader to = (ToHeader)res.getHeader("To");
        Random rand = new Random();
        to.setTag(String.valueOf(rand.nextInt(999999)));
        Address addr = this.addressFactory.createAddress((URI)this.uri);
        ContactHeader contact = this.headerFactory.createContactHeader(addr);
        res.setHeader((Header)contact);
    }

    void sendRequest(Entity target, String method) throws SipException {
        Request req = this.createRequest(target, this.con, method);
        if (method.equals("REGISTER")) {
            try {
                ExpiresHeader expires = this.headerFactory.createExpiresHeader(DEFAULT_EXPIRES);
                req.setExpires(expires);
                Address contact_addr = this.addressFactory.createAddress((URI)this.con.getURI());
                contact_addr.setDisplayName(this.con.getName());
                ContactHeader contact = this.headerFactory.createContactHeader(contact_addr);
                req.setHeader((Header)contact);
            }
            catch (Exception e) {
                throw new SipException(e.getMessage());
            }
        }
        if (method.equals("SUBSCRIBE")) {
            PIDFFactoryImpl pidf_fac = new PIDFFactoryImpl(this.con);
            PIDFData data = pidf_fac.createPIDF();
            try {
                req.setContent((Object)data.toString(), this.headerFactory.createContentTypeHeader("application", "pidf+xml"));
                ExpiresHeader expires = this.headerFactory.createExpiresHeader(DEFAULT_EXPIRES);
                req.setExpires(expires);
                EventHeader event = this.headerFactory.createEventHeader(event_package);
                req.setHeader((Header)event);
                Address contact_addr = this.addressFactory.createAddress((URI)this.con.getURI());
                contact_addr.setDisplayName(this.con.getName());
                ContactHeader contact = this.headerFactory.createContactHeader(contact_addr);
                req.setHeader((Header)contact);
            }
            catch (Exception e) {
                throw new SipException(e.getMessage());
            }
        }
        ClientTransaction ct = this.provider.getNewClientTransaction(req);
        ct.sendRequest();
        logger.info((Object)("Sending " + method + " to " + target.getURI()));
        Dialog dialog = ct.getDialog();
        if (dialog != null) {
            dialogTable.put(target.getURI().toString(), dialog);
        }
    }

    void sendRequest(String message, Entity target, Entity source, String method) throws SipException, ParseException {
        String name = target.getURI().toString();
        if (method.equals("INVITE")) {
            Request req = this.createRequest(target, source, method);
            Address contact_addr = this.addressFactory.createAddress((URI)source.getURI());
            ContactHeader contact = this.headerFactory.createContactHeader(contact_addr);
            req.setHeader((Header)contact);
            req.setContent((Object)message, this.headerFactory.createContentTypeHeader("application", "sdp"));
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            ct.sendRequest();
            dialogTable.put(name, ct.getDialog());
        } else if (method.equals("MESSAGE")) {
            Request req = this.createRequest(target, source, method);
            FromHeader from = (FromHeader)req.getHeader("From");
            Address addr = this.addressFactory.createAddress((URI)source.getURI());
            addr.setDisplayName(source.getFullyQualifiedName());
            from.setAddress(addr);
            req.setContent((Object)message, this.headerFactory.createContentTypeHeader("text", "plain"));
            this.provider.sendRequest(req);
        } else {
            Dialog dialog = dialogTable.get(name);
            Request req = dialog.createRequest(method);
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            dialog.sendRequest(ct);
        }
    }

    private Request createRequest(EntityListener target, Entity source, String method) throws SipException {
        Request req;
        Address toAddress = this.addressFactory.createAddress((URI)target.getURI());
        String branch = null;
        String tag = "" + this.rand.nextInt(100000000);
        try {
            ToHeader to = this.headerFactory.createToHeader(toAddress, null);
            Address fromAddress = this.addressFactory.createAddress((URI)source.getURI());
            fromAddress.setDisplayName(source.getName());
            FromHeader from = this.headerFactory.createFromHeader(fromAddress, tag);
            CSeqHeader cSeq = this.headerFactory.createCSeqHeader(1L, method);
            CallIdHeader callId = this.provider.getNewCallId();
            MaxForwardsHeader maxForwards = this.headerFactory.createMaxForwardsHeader(70);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            String ipAddr = this.provider.getListeningPoint(TRANSPORT).getIPAddress();
            int port = this.provider.getListeningPoint(TRANSPORT).getPort();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(ipAddr, port, TRANSPORT, branch);
            viaHeaders.add(viaHeader);
            req = this.messageFactory.createRequest(to.getAddress().getURI(), method, callId, cSeq, from, to, viaHeaders, maxForwards);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SipException(e.getMessage());
        }
        return req;
    }

    void startNotify(String sender_name, Dialog dialog) throws ParseException {
        logger.info((Object)("Start NotifyTask to:" + sender_name));
        this.task = new NotifyTask(dialog);
        this.task.start();
    }

    public void refresh() {
        if (this.task != null) {
            logger.info((Object)"Refresh expires.");
            this.task.refresh();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipURI createURI(String uri_str) {
        try {
            if (this.addressFactory != null) {
                URI temp = this.addressFactory.createURI(uri_str);
                if (!temp.isSipURI()) throw new IllegalArgumentException(String.valueOf(temp.toString()) + " is not valid SIP URI.");
                return (SipURI)temp;
            }
            SipUri s_uri = new SipUri();
            StringTokenizer stToken = new StringTokenizer(uri_str, "@:");
            String scheme = stToken.nextToken();
            if (!scheme.equals("sip") && !scheme.equals("pres")) {
                throw new IllegalArgumentException("Bad uri scheme :" + scheme);
            }
            String user = stToken.nextToken();
            String host = stToken.nextToken();
            int port = Integer.parseInt(stToken.nextToken());
            s_uri.setUser(user);
            s_uri.setHost(host);
            s_uri.setPort(port);
            return s_uri;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private String getHostName() throws IOException {
        String name = "";
        Enumeration<NetworkInterface> enuIfs = NetworkInterface.getNetworkInterfaces();
        if (enuIfs != null) {
            block0: while (enuIfs.hasMoreElements()) {
                NetworkInterface ni = enuIfs.nextElement();
                if (ni.getName().equals("lo")) continue;
                Enumeration<InetAddress> enuAddrs = ni.getInetAddresses();
                while (enuAddrs.hasMoreElements()) {
                    InetAddress in4 = enuAddrs.nextElement();
                    if (!(in4 instanceof Inet4Address)) continue;
                    name = in4.getHostName();
                    continue block0;
                }
            }
        }
        return name;
    }

    private String getIpAddress(String name) throws IOException {
        String address = "";
        Enumeration<NetworkInterface> enuIfs = NetworkInterface.getNetworkInterfaces();
        if (enuIfs != null) {
            while (enuIfs.hasMoreElements()) {
                NetworkInterface ni = enuIfs.nextElement();
                Enumeration<InetAddress> enuAddrs = ni.getInetAddresses();
                boolean flag = false;
                while (enuAddrs.hasMoreElements()) {
                    InetAddress in4 = enuAddrs.nextElement();
                    if (ni.getName().equals("lo")) continue;
                    if (in4 instanceof Inet4Address) {
                        address = in4.getHostAddress();
                        flag = true;
                        break;
                    }
                    if (flag) break;
                }
                if (flag) break;
            }
        }
        return address;
    }

    public SipURI getURI() {
        return this.uri;
    }

    private class NotifyTask
    extends TimerTask {
        private static final String eventPackage = "presence";
        private PIDFData temp = null;
        private Dialog dialog;
        private boolean alive = false;
        private Timer timer;
        private Address fromAddress;

        public NotifyTask(Dialog dialog) throws ParseException {
            this.dialog = dialog;
            this.alive = true;
            this.fromAddress = SipCore.this.addressFactory.createAddress((URI)SipCore.this.con.getURI());
            this.fromAddress.setDisplayName(SipCore.this.con.getName());
        }

        public void start() {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)this, 1000L, (long)(DEFAULT_EXPIRES * 1000));
        }

        public void run() {
            try {
                this.sendNotify();
            }
            catch (Exception e) {
                logger.warn((Object)"Error while sending NOTIFY MESSAGE", (Throwable)e);
            }
        }

        public void sendNotify() throws SipException, ParseException {
            Request notify = this.dialog.createRequest("NOTIFY");
            SubscriptionStateHeader state = SipCore.this.headerFactory.createSubscriptionStateHeader("Active");
            EventHeader event = SipCore.this.headerFactory.createEventHeader(eventPackage);
            PIDFData pidf = SipCore.this.pidfFactory.createPIDF();
            if (this.temp == null || !this.temp.equals(pidf)) {
                ContentTypeHeader contentType = SipCore.this.headerFactory.createContentTypeHeader("application", "pidf+xml");
                notify.addHeader((Header)state);
                notify.addHeader((Header)event);
                notify.setContent((Object)pidf.toString(), contentType);
            }
            ClientTransaction ct = SipCore.this.provider.getNewClientTransaction(notify);
            if (this.alive) {
                logger.info((Object)("Sending NOTIFY to " + this.dialog.getRemoteTarget()));
                this.dialog.sendRequest(ct);
                this.alive = false;
            } else {
                logger.info((Object)"Expires out, remove Parent");
                this.timer.cancel();
                EntityEvent evt = new EntityEvent((EntityContainer)SipCore.this.con.getParent());
                evt.setEventType(EntityEvent.EventType.REMOVE);
                EntityEventDispatcher dispatcher = EntityEventDispatcher.getInstance();
                this.dialog.delete();
                dispatcher.dispatchEvent(evt);
            }
        }

        public void refresh() {
            this.alive = true;
        }
    }

    private class EntityEventListener
    implements EntityListener {
        ExecutorService ex = Executors.newCachedThreadPool();

        private EntityEventListener() {
        }

        public void receiveMessage(EntityEvent e) {
            EntityListener entityListener = e.getTarget();
            switch (e.getEventType()) {
                case INIT: {
                    try {
                        instance.sendRequest((Entity)e.getTarget(), "REGISTER");
                    }
                    catch (SipException se) {
                        logger.error((Object)("Error while sending REGISTER to " + entityListener.toString()), (Throwable)se);
                    }
                    break;
                }
                case MESSAGE: {
                    if (e.isBroadcast()) {
                        Set<Entity> entities = SipCore.this.con.getEntities();
                        for (EntityListener entityListener2 : entities) {
                            if (entityListener2.isLocal() || !(entityListener2 instanceof EntityContainer)) continue;
                            try {
                                Request req = instance.createRequest(entityListener2, SipCore.this.con, "MESSAGE");
                                req.setContent((Object)e.getMessage(), SipCore.this.headerFactory.createContentTypeHeader("text", "plain"));
                                SipCore.this.provider.sendRequest(req);
                            }
                            catch (Exception e1) {
                                logger.warn((Object)("Error while sending MESSAGE to " + entityListener2), (Throwable)e1);
                            }
                            logger.info((Object)("Send MESSAGE to " + entityListener2.getURI()));
                        }
                        break;
                    }
                    Entity source = (Entity)e.getSource();
                    Set<TreeNode> set = SipCore.this.con.getChildNodes();
                    if (!source.isLocal() || entityListener.isLocal()) {
                        return;
                    }
                    if (!set.contains(entityListener) && SipCore.this.con.include((TreeNode)((Object)entityListener)) && !entityListener.equals(SipCore.this.con)) {
                        try {
                            Request req = instance.createRequest(entityListener, SipCore.this.con, "MESSAGE");
                            req.setContent((Object)e.getMessage(), SipCore.this.headerFactory.createContentTypeHeader("text", "plain"));
                            SipCore.this.provider.sendRequest(req);
                        }
                        catch (Exception e1) {
                            logger.warn((Object)("Error while sending MESSAGE to " + entityListener), (Throwable)e1);
                        }
                        logger.info((Object)("Send MESSAGE to " + entityListener.getURI()));
                        break;
                    }
                    logger.info((Object)("No External Entry :" + entityListener.getURI()));
                }
            }
        }

        public SessionDescription receiveOffer(EntityEvent evt) {
            Entity target = (Entity)evt.getTarget();
            if (target.isLocal()) {
                return null;
            }
            Entity source = (Entity)evt.getSource();
            try {
                instance.sendRequest(evt.getSessionDescription().toString(), target, source, "INVITE");
            }
            catch (Exception e) {
                logger.warn((Object)("Error while sending INVITE to " + target), (Throwable)e);
            }
            return null;
        }

        public void receiveBye(EntityEvent evt) {
            Entity target = (Entity)evt.getTarget();
            if (target.isLocal()) {
                return;
            }
            Entity source = (Entity)evt.getSource();
            try {
                instance.sendRequest("", target, source, "BYE");
            }
            catch (Exception e) {
                logger.warn((Object)("Error while sending BYE to " + target), (Throwable)e);
            }
        }

        public void receiveAnswer(EntityEvent e) {
            Entity source = (Entity)e.getSource();
            Request req = e.getRequest();
            Response res = null;
            if (req == null) {
                return;
            }
            try {
                res = SipCore.this.messageFactory.createResponse(200, req);
                if (e.getSessionDescription() != null) {
                    ContentTypeHeader type = SipCore.this.headerFactory.createContentTypeHeader("application", "sdp");
                    res.setContent((Object)e.getSessionDescription().toString(), type);
                }
                Address contact_addr = SipCore.this.addressFactory.createAddress((URI)source.getURI());
                contact_addr.setDisplayName(source.getName());
                ContactHeader contact = SipCore.this.headerFactory.createContactHeader(contact_addr);
                res.setHeader((Header)contact);
                Entity target = (Entity)e.getTarget();
                String uri = target.getURI().toString();
                Dialog dialog = (Dialog)dialogTable.get(uri);
                ServerTransaction st = (ServerTransaction)dialog.getApplicationData();
                st.sendResponse(res);
                logger.info((Object)("Sending Response 200(OK) to " + uri));
            }
            catch (Exception e1) {
                logger.warn((Object)"Error while creating Response", (Throwable)e1);
                return;
            }
        }

        public void addedNewEntity(EntityEvent e) {
            switch (e.getEventType()) {
                case REGISTER: {
                    Entity target = (Entity)e.getSource();
                    try {
                        SipCore.this.sendRequest(target, "SUBSCRIBE");
                    }
                    catch (SipException e1) {
                        logger.warn((Object)("Error while sending SUBSCRIBE to " + target.getURI()), (Throwable)e1);
                    }
                    break;
                }
                case SUBSCRIBE: {
                    String target_uri = e.getFrom().toString();
                    Dialog dialog = (Dialog)dialogTable.get(target_uri);
                    try {
                        SipCore.this.startNotify(target_uri, dialog);
                    }
                    catch (ParseException e2) {
                        logger.warn((Object)("Error while sending NOTIFY to " + target_uri), (Throwable)e2);
                    }
                    break;
                }
                case NOTIFY: {
                    String target_uri = e.getFrom().toString();
                    Entity temp = SipCore.this.con.getEntity(target_uri);
                    if (temp == null) {
                        logger.warn((Object)("Already expires out :" + target_uri));
                        return;
                    }
                    EntityContainerImpl target_container = (EntityContainerImpl)temp;
                    if (target_container.isRunning()) {
                        target_container.refresh();
                        logger.info((Object)("Refresh timer :" + target_container));
                        break;
                    }
                    this.ex.execute(target_container);
                    logger.info((Object)("Running timer :" + target_container));
                }
                case ADD: {
                    if (e.getSource() instanceof Entity) {
                        return;
                    }
                    String target_uri = e.getFrom().toString();
                    String pidf = e.getMessage();
                    Set set = dialogTable.keySet();
                    for (String uri : set) {
                        if (uri.equals(target_uri)) continue;
                        Dialog dialog = (Dialog)dialogTable.get(uri);
                        try {
                            Request req = dialog.createRequest("MESSAGE");
                            ClientTransaction ct = SipCore.this.provider.getNewClientTransaction(req);
                            req.setContent((Object)pidf, SipCore.this.headerFactory.createContentTypeHeader("application", "pidf+xml"));
                            dialog.sendRequest(ct);
                            logger.info((Object)("Forwarding PIDF to :" + uri));
                        }
                        catch (Exception e1) {
                            logger.error((Object)("Error while sending MESSAGE message to " + uri), (Throwable)e1);
                        }
                    }
                    break;
                }
                default: {
                    logger.warn((Object)"Invalid Operation");
                }
            }
        }

        public void receiveAck(EntityEvent e) {
            Entity target = (Entity)e.getTarget();
            Dialog dialog = (Dialog)dialogTable.get(target.getURI().toString());
            try {
                Request ack = dialog.createAck(dialog.getLocalSeqNumber());
                logger.info((Object)("Send ACK to " + dialog.getRemoteTarget()));
                dialog.sendAck(ack);
            }
            catch (Exception e1) {
                logger.warn((Object)"Error while sending ACK", (Throwable)e1);
            }
        }

        public void removedEntity(EntityEvent evt) {
            EntityContainer con = (EntityContainer)evt.getSource();
            PIDFFactoryImpl fac = new PIDFFactoryImpl(con);
            PIDFData data = fac.createPIDF();
            String key = con.getURI().toString();
            if (con == instance.con.getParent()) {
                instance.task = null;
                dialogTable.remove(key);
            } else {
                Dialog dialog = (Dialog)dialogTable.get(key);
                if (dialog != null) {
                    dialog.delete();
                }
                dialogTable.remove(key);
            }
            Set set = dialogTable.keySet();
            for (String uri : set) {
                Dialog dialog = (Dialog)dialogTable.get(uri);
                try {
                    Request req = dialog.createRequest("MESSAGE");
                    ClientTransaction ct = SipCore.this.provider.getNewClientTransaction(req);
                    req.setContent((Object)data, SipCore.this.headerFactory.createContentTypeHeader("application", "pidf+xml"));
                    dialog.sendRequest(ct);
                    logger.info((Object)("Sending PIDF to :" + uri));
                }
                catch (Exception e1) {
                    logger.error((Object)("Error while sending MESSAGE message to " + uri), (Throwable)e1);
                }
            }
        }

        public SipURI getURI() {
            return null;
        }

        public boolean isLocal() {
            return false;
        }

        public void setURI(SipURI uri) {
        }
    }
}

