/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.SipURI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.message.Request;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.PIDFParser;
import jp.ac.naka.ec.sip.pidf.PIDFParserImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.SAXException;

class SubscribeDelegate
extends MethodDelegate {
    public static int MIN_EXPIRES = 10;
    private static final String[] acceptPackages = new String[]{"presence"};
    private static Log logger = LogFactory.getLog(SubscribeDelegate.class);
    private PIDFParser parser = PIDFParserImpl.getInatance();

    public SubscribeDelegate() throws ParserConfigurationException, SAXException {
        this.core = SipCore.getInstance();
        PropertyConfigurator.configure((String)Main.log4j_properties);
        this.dispatcher = TupleSpaceAdapter.getInstance();
    }

    public boolean forward(RequestEvent evt) {
        Request req;
        block9: {
            req = evt.getRequest();
            try {
                EventHeader event = (EventHeader)req.getHeader("Event");
                if (this.checkEventHeader(event)) break block9;
                logger.warn((Object)"Bad event.");
                this.core.sendResponse(489, req);
                return false;
            }
            catch (Exception e1) {
                logger.warn((Object)"Error while send a response.", (Throwable)e1);
                return false;
            }
        }
        ExpiresHeader expires = (ExpiresHeader)req.getHeader("Expires");
        if (!this.checkExpiresHeader(expires)) {
            logger.warn((Object)"Interval is too brief.");
            this.core.sendResponse(423, req);
            return false;
        }
        ContentTypeHeader type = (ContentTypeHeader)req.getHeader("Content-Type");
        if (type.getContentType().equals("application") && type.getContentSubType().equals("pidf+xml")) {
            byte[] content = req.getRawContent();
            if (content == null) {
                throw new NullPointerException("Notify has no body!");
            }
            try {
                PIDFData data = this.parser.parse(content);
                FromHeader from = (FromHeader)req.getHeader("From");
                SipURI fromUri = (SipURI)from.getAddress().getURI();
                Entity[] entities = this.makeEntitiesFromPIDF(data);
                EntityEvent ee = new EntityEvent(entities);
                ee.setEventType(EntityEvent.EventType.SUBSCRIBE);
                ee.setFrom(fromUri);
                ee.setMessage(new String(content, "UTF-8"));
                this.core.sendResponse(200, evt, fromUri.toString());
                this.dispatcher.dispatchEvent(ee);
            }
            catch (Exception e) {
                logger.warn((Object)"Error occures while processing PIDF :", (Throwable)e);
                return false;
            }
        } else {
            logger.warn((Object)("Invalid ContentType: " + type.toString()));
            return false;
        }
        return true;
    }

    private boolean checkExpiresHeader(ExpiresHeader expires) {
        int expire = expires.getExpires();
        return expire > MIN_EXPIRES;
    }

    private boolean checkEventHeader(EventHeader header) {
        String type = header.getEventType();
        String[] stringArray = acceptPackages;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String str = stringArray[n];
            if (str.equals(type)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

