/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec;


import javax.sip.address.SipURI;

import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityListener;
import net.sourceforge.jsdp.SessionDescription;

/**
 * CxgzMpPluginƂ͂̃NXgĂB
 * @author Takashi Kasuya
 *
 */
abstract public class EventSource implements Plugin {

	protected SipURI uri;
	protected String name;
	/*
	 * 
	 */
	protected EventDispatcher dispatcher = TupleSpaceAdapter.getInstance();

	
	/**
	 * EventDispatcher̃CX^X𓾂B
	 * @return
	 */
	public EventDispatcher getEventDispatcher() {
		return dispatcher;
	}

	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#addedNewEntity(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void addedNewEntity(EntityEvent e) {
	}

	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#receiveAnswer(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void receiveAnswer(EntityEvent e) {
	}

	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#receiveBye(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void receiveBye(EntityEvent e) {
	}

	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#receiveMessage(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void receiveMessage(EntityEvent e) {
	}

	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#receiveOffer(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public SessionDescription receiveOffer(EntityEvent e) {
		return null;
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#receiveAck(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void receiveAck(EntityEvent evt){}

	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.Plugin#getPluginName()
	 */
	public String getPluginName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.Plugin#getURI()
	 */
	public SipURI getURI() {
		return uri;
	}

	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.Plugin#setPluginName(java.lang.String)
	 */
	public void setPluginName(String string) {
		this.name = string;
	}

	
	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#removedEntity(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void removedEntity(EntityEvent evt) {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public boolean equals (Object obj) {
		if (getURI() == null) {
			return super.equals(obj);
		} else if (obj instanceof EntityListener) {
			EntityListener node = (EntityListener)obj;
			boolean a = node.getURI().toString().equals(getURI().toString());
			return a;
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#isLocal()
	 */
	public boolean isLocal() {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.entity.EntityListener#setURI(javax.sip.address.SipURI)
	 */
	public void setURI(SipURI uri) {
		this.uri = uri;
	}

}