/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/**
 * TreeNode̎NX
 * @author Takashi Kasuya
 * 
 */
public class TreeNodeImpl implements TreeNode {

	private List<TreeNode> children;
	private TreeNode parent;
	private String name;
	
	/**
	 * RXgN^
	 * 
	 */
	public TreeNodeImpl() {
		children = new Vector<TreeNode>();
	}

	/**
	 * ew肵ăCX^X𐶐
	 * 
	 * @param parent
	 */
	public TreeNodeImpl(TreeNode parent) {
		this();
		setParent(parent);
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#addChild(jp.ac.naka.ec.TreeNode)
	 */
	public void addChild(TreeNode node) {
		children.add(node);
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#getChildNodes()
	 */
	public Set<TreeNode> getChildNodes() {
		Set set = null;
		if (children.isEmpty()) {
			set = new HashSet();
		} else {
			set = new HashSet<TreeNode>(children);
		}
		return set;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#getFullyQualifiedName()
	 */
	public String getFullyQualifiedName() {
		String fqfn = "";
		if (hasParent()) {
			fqfn += getParent().getFullyQualifiedName()+".";
		}
		fqfn += getName();
		return fqfn;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#hasChildNodes()
	 */
	public boolean hasChildNodes() {
		return !children.isEmpty();
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#hasParent()
	 */
	public boolean hasParent() {
		return (parent != null) ? true : false;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#removeChild(jp.ac.naka.ec.TreeNode)
	 */
	public boolean removeChild(TreeNode node) {
		boolean a = false;
		if (children.contains(node)) {
			children.remove(node);
			a = true;
		}
		return a;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.iobb.ibaraki.struct.TreeNode#getParent()
	 */
	public TreeNode getParent() {
		return parent;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#setParent(jp.ac.naka.ec.TreeNode)
	 */
	public void setParent(TreeNode node) {
		this.parent = node;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#getName()
	 */
	public String getName() {
		return this.name;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals (Object obj) {
		if (getFullyQualifiedName() == null) {
			return super.equals(obj);
		} else if (obj instanceof TreeNode) {
			TreeNode node = (TreeNode)obj;
			boolean a = node.getFullyQualifiedName().equals(getFullyQualifiedName());
			return a;
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.TreeNode#include(jp.ac.naka.ec.TreeNode)
	 */
	public boolean include(TreeNode node) {
		return  ( node.getFullyQualifiedName().indexOf(getFullyQualifiedName()) !=  -1);
	}
}
