/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


package jp.ac.naka.ec.entity;

import java.util.List;
import java.util.Vector;

import jp.ac.naka.ec.EventDispatcher;

/**
 * EntityEvent̔zzsNXB
 * 
 * @author Takashi Kasuya
 * 
 */
public class EntityEventDispatcher implements EventDispatcher {
	private static EntityEventDispatcher instance = new EntityEventDispatcher();

	private List<EntityListener> listeners;

	
	private EntityEventDispatcher() {
		listeners = new Vector<EntityListener>();
	}

	/**
	 * 
	 * @return
	 */
	public static EntityEventDispatcher getInstance() {
		return instance;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.EventDispatcher#addEntityListener(jp.ac.naka.ec.entity.EntityListener)
	 */
	public synchronized void addEntityListener(EntityListener listener) {
		listeners.add(listener);
	}

	
	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.EventDispatcher#dispatchEvent(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public void dispatchEvent(EntityEvent evt) {

		for (EntityListener listener : listeners) {
			switch (evt.getEventType()) {
			case MESSAGE:
				listener.receiveMessage(evt);
				break;
			// TODO
			case OFFER: listener.receiveOffer(evt); break;
			case BYE : listener.receiveBye(evt); break;
			case ANSWER:listener.receiveAnswer(evt); break;
			case ADD : listener.addedNewEntity(evt); break;
			case NOTIFY : listener.addedNewEntity(evt); break;
			case SUBSCRIBE : listener.addedNewEntity(evt); break;
			case REGISTER : listener.addedNewEntity(evt); break;
			case ACK:listener.receiveAck(evt); break;
			case REMOVE:listener.removedEntity(evt); break;
			default:
				listener.receiveMessage(evt);
			}

		}
	}

}
