/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity;

import java.util.EventListener;

import javax.sip.address.SipURI;

import net.sourceforge.jsdp.SessionDescription;

public interface EntityListener extends EventListener{
	
	/**
	 * bZ[Wۂ̃R[obN
	 * @param e
	 * @return a
	 */
	public void receiveMessage(EntityEvent e);
	
	/**
	 * ZbṼIt@[ۂ̃R[obN
	 * @param e
	 * @return
	 */
	public SessionDescription receiveOffer(EntityEvent e);

	/**
	 * OfferNGXg̃X|X󂯂Ƃ̃R[obN
	 * 
	 * @param e
	 */
	public void receiveAnswer(EntityEvent e);
	
	/**
	 * ByeNGXg󂯂Ƃ̃R[obN
	 * @param e
	 */
	public void receiveBye(EntityEvent e);
	
	/**
	 * AckNGXg󂯂Ƃ̃R[obN
	 */
	public void receiveAck(EntityEvent e);
	/**
	 * VEntityǉꂽƂɌĂ΂R[obN
	 * @param e
	 */
	public void addedNewEntity (EntityEvent e);

	/**
	 * Entity̎QƂꂽƂɌĂ΂R[obN
	 * @param evt
	 */
	public void removedEntity(EntityEvent evt);

	/**
	 * [JɂEntityǂB
	 * 
	 * @return
	 */
	public boolean isLocal();

	/**
	 * 
	 * @param uri
	 */
	public void setURI(SipURI uri);

	/**
	 * 
	 * @return
	 */
	public SipURI getURI();

}
