/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity.test;

import java.io.IOException;

import javax.media.MediaException;
import javax.swing.JTextArea;

import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.MediaTransmitter;
import net.sourceforge.jsdp.SessionDescription;

/**
 * NGXg󂯂āArfI\[X̃Xg[~OsEntityB|[g44444B
 * @author Takashi Kasuya
 * 
 */
public class VideoTransmitterEntity extends AbstractEntity {
	MediaTransmitter vt;


	JTextArea field = new JTextArea();

	Entity callee;

	@Override
	public void init() {
		int port = 44444;
		setName("MediaTransmitter");
		setEntityType(EntityType.MEDIA_TRANSMITTER);

		vt = new MediaTransmitter();
		vt.setVideoPort(port);
		vt.enableAudio(false);
	}

	@Override
	public void receiveMessage(EntityEvent e) {
		StringBuilder st = new StringBuilder();
		st.append(field.getText());
		st.append(e.getMessage() + "\n");
		field.setText(st.toString());
	}

	@Override
	public SessionDescription receiveOffer(
			EntityEvent evt) {
		SessionDescription sdp = evt.getSessionDescription();
		SessionDescription temp = vt.getResponseSessionDescription(sdp);

		try {
			if (!vt.isPlaying())
				vt.sendMedia(temp);
		} catch (MediaException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return temp;
	}
	
	@Override
	public void receiveBye(EntityEvent e) {
		if (vt.isPlaying())
			vt.close();
	}
}
