/*
 *  Copyright (C) 2007  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.plugin.flash;

import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;

/**
 * message^Õf[^𔲂oăCxgƂ邲yB Flash<message>test</message>̂悤ɃNGXgĂB
 * 
 * @author J
 * 
 */
public class FlashXMLParserImpl implements FlashXMLParser {

	private Entity source;

	public FlashXMLParserImpl(){}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.ac.naka.ec.flash.FlashXMLParser#parseXML()
	 */
	public EntityEvent parseXML(String xmlString) {
		// <message>test</message>
		int index = xmlString.indexOf("<message>") + "<message>".length();
		int endIndex = xmlString.indexOf("</message>");
		if (index != -1 && endIndex != -1) {
			String data = xmlString.substring(index, endIndex);
			EntityEvent evt = new EntityEvent(data, null, source);
			evt.setBroadcast(true);
			return evt;
		} else
			return null;
	}

	public void setEventSource(Entity source) {
		this.source = source;
	}

}
