/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.plugin.http;

import java.util.Properties;

import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.plugin.serial.ForAjaxParser;

import org.apache.log4j.Logger;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;

/**
 * WebT[oƂċ@\AHTTP̃Cxg̓o͂ǗB
 * httptH_ȉ̐ÓIWeb\[Xǂݍݕ\BftHgWebւ̃ANZX|[g8080B
 * 
 * @author Takashi Kasuya
 * 
 */
public class HttpCore extends EventSource {

	HttpServer server;

	/*
	 * Default port is 8080
	 */
	public static int DEFAULT_PORT = 8080;
	

	/**
	 * 
	 * 
	 */
	public HttpCore() {
	}

	/* (non-Javadoc)
	 * @see jp.ac.naka.ec.Plugin#init(jp.ac.naka.ec.entity.EntityContainer)
	 */
	public void init(EntityContainer source) throws Exception {
		int port = HttpCore.DEFAULT_PORT;
		String base = "./html";
			
		server = new HttpServer();
		SocketListener listener = new SocketListener();
		listener.setPort(port);
		server.addListener(listener);

		HttpContext context = new HttpContext();
		context.setContextPath("/");
		
		HttpHandlerExt handler = new AjaxHandler();
		handler.setSourceEntity(source);
		context.addHandler(handler);
		
		context.setResourceBase(base);
		context.addHandler(new ResourceHandler());
		server.addContext(context);
		server.start();
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.Plugin#init(jp.ac.naka.ec.entity.EntityContainer, java.util.Properties)
	 */
	public void init(EntityContainer source, Properties prop) throws Exception {
		String t = prop.getProperty("port");
		int port = HttpCore.DEFAULT_PORT;
		if ( t != null && !t.equals(""))
			port = Integer.parseInt(t);
		String base = "./html";
		t = prop.getProperty("resourceBase");
		if ( t != null && !t.equals(""))
			base = t;
		
			
		server = new HttpServer();
		SocketListener listener = new SocketListener();
		listener.setPort(port);
		server.addListener(listener);

		HttpContext context = new HttpContext();
		context.setContextPath("/");
		context.setResourceBase(base);
		// HTTPResponsegbv_ňϏI
		t= prop.getProperty("handler");
		if ( t != null && !t.equals("")) {
			Class clz = Class.forName(t);
			HttpHandlerExt handler = (HttpHandlerExt)clz.newInstance();
			handler.setSourceEntity(source);
			context.addHandler(handler);
		}
		context.addHandler(new ResourceHandler());
		server.addContext(context);
		server.start();
	}

	/**
	 * 
	 * @return
	 */
	public boolean isStarted() {
		if (server == null)
			return false;
		return server.isStarted();
	}

	/**
	 * 
	 * @throws InterruptedException
	 */
	public void stopServer() throws InterruptedException {
		server.stop();
	}
}
