/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.plugin.serial;

import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;


/**
 * eXgpp[TBvalue:̌`ɐ`Au[hLXgB
 * @author J
 *
 */
public class ForAjaxParser implements SerialInputParser{
	static int num = 0;
	
	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.plugin.serial.SerialInputParser#parse(java.lang.String, jp.ac.naka.ec.entity.Entity)
	 */
	public EntityEvent parse(String str, Entity source) {
		String temp=str;
		int index;
		if ((index=str.indexOf("=")) != -1) {
			float value = Float.parseFloat(str.substring(index+1));
			temp = "value:" + Math.round(value/1024 * 100);
		}
		EntityEvent evt = new EntityEvent(temp, null, source);
		evt.setBroadcast(true);
		return evt;
	}

}
