/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.plugin.serial;

import java.util.Date;

/**
 * 
 * @author Takashi Kasuya
 *
 */

public class MoxaSensorData implements SensorData{
	int sensor_type = 0;
	int id = 0;
	String sensor_value;
	int seqNumber = 0;
	int srcAddr;
	int srcPanId = 0;
	int rssi;
	long timestamp;
	
	public MoxaSensorData(int type, int seq, int addr, int id, String value, int rssi) {
		this.sensor_type = type;
		this.sensor_value = value;
		this.srcAddr = addr;
		this.seqNumber = seq;
		this.srcPanId = id;
		this.rssi = rssi;
		this.timestamp = new Date().getTime();
	}
	
	public MoxaSensorData(int type, String value, int addr, int panId, long timestamp2) {
		this(type, 0, addr, panId, value, 0);
		this.timestamp = timestamp2;
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Sensor Type:" + MoxaDeviceType.getSensorTypeString(sensor_type) + ", Sensor Value:" + sensor_value;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.plugin.serial.SensorData#getSensorType()
	 */
	public int getSensorType() {
		return sensor_type;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.plugin.serial.SensorData#getRssi()
	 */
	public int getRssi() {
		return rssi;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.plugin.serial.SensorData#getSensorValue()
	 */
	public String getSensorValue() {
		return sensor_value;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.plugin.serial.SensorData#getSeqNumber()
	 */
	public int getSeqNumber() {
		return seqNumber;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.plugin.serial.SensorData#getSrcAddr()
	 */
	public int getSrcAddr() {
		return srcAddr;
	}

	/* (non-Javadoc)
	 * @see net.iobb.db.SensorDatas#getSrcPanId()
	 */
	public int getSrcPanId() {
		return srcPanId;
	}

	
	public long getTimestamp() {
		return timestamp;
	}

	public void setId(int num) {
		id = num;
	}
	
	public int getId() {
		return id;
	}
	
}
