/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.address.SipURI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityEvent.EventType;
import net.sourceforge.jsdp.SdpMessageParser;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/**
 * @author Takashi Kasuya
 * 
 */
class InviteDelegate extends MethodDelegate {

	private static Logger logger = Logger.getLogger(InviteDelegate.class);

	public InviteDelegate() {
		PropertyConfigurator.configure(Main.log4j_properties);
		dispatcher = EntityEventDispatcher.getInstance();
		core = SipCore.getInstance();
	}

	public boolean forward(RequestEvent evt) {
		Request req = evt.getRequest();

		ContentTypeHeader type = (ContentTypeHeader) req
				.getHeader(ContentTypeHeader.NAME);
		FromHeader from = (FromHeader) req.getHeader(FromHeader.NAME);

		if (type.getContentType().equals("application")
				&& type.getContentSubType().equals("sdp")) {
			try {
				byte[] raw = req.getRawContent();
				if (isMidRequest(evt)) {
					// TODO
					core.sendResponse(Response.SERVER_INTERNAL_ERROR, evt, from
							.getAddress().getURI().toString());
					return false;
				}
				net.sourceforge.jsdp.SessionDescription sdp = null;

				if (raw != null) {
					String sdp_str = new String(raw, "UTF-8");
					sdp = SdpMessageParser.getSessionDescription(sdp_str);
				}
				ToHeader to = (ToHeader) req.getHeader(ToHeader.NAME);
				SipURI targetURI = (SipURI) to.getAddress().getURI();
				SipURI sourceURI = (SipURI) from.getAddress().getURI();

				Entity target = new EntityImpl(targetURI);
				Entity source = new EntityImpl(sourceURI);
				source.setLocal(false);
				EntityEvent e = new EntityEvent(sdp, target, source);
				core.sendResponse(Response.TRYING, evt, sourceURI.toString());
				e.setEventType(EventType.OFFER);
				e.setRequest(req);

				dispatcher.dispatchEvent(e);

			} catch (Exception e) {
				logger.warn("Error while processing SDP.", e);
				try {
					core.sendResponse(Response.SERVER_INTERNAL_ERROR, evt, from
							.getAddress().getURI().toString());
				} catch (Exception e1) {
					logger.warn("Cannot send a error Response.", e);
				}
				return false;
			}
		} else {
			logger.warn("Unsuported Content-Type: +" + type.toString());
			return false;
		}
		return true;
	}

	private boolean isMidRequest(RequestEvent evt) {
		ServerTransaction st = evt.getServerTransaction();
		return (st != null) ? true : false;
	}

}
