/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;

/**
 * 
 * @author Takashi Kasuya
 *
 */

class RequestDelegate extends MethodDelegate {

	private InviteDelegate invite;
	private RegisterDelegate register;
	private SubscribeDelegate subscribe;
	private NotifyDelegate notify;
	private MessageDelegate message;
	private ByeDelegate bye;
	
	/**
	 * 
	 *
	 */
	public RequestDelegate() {
		try {
			subscribe = new SubscribeDelegate();
			register = new RegisterDelegate();
			notify = new NotifyDelegate();
			message = new MessageDelegate();
			invite = new InviteDelegate();
			bye = new ByeDelegate();
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}
	/* (non-Javadoc)
	 * @see jp.ac.naka.sip.delegate.MethodDelegate#forward(javax.sip.RequestEvent)
	 */
	public boolean forward(final RequestEvent evt) {
		
		RequestType temp = RequestType.valueOf(evt.getRequest().getMethod());
		switch (temp) {
		case ACK:
			break;
		case REGISTER:
			register.forward(evt);
			break;
		case INVITE:
			invite.forward(evt);
			break;
		case CANCEL:
			break;
		case BYE :
			bye.forward(evt);
			break;
		case PUBLISH:
			throw new UnsupportedOperationException("PUBLISH is not implemented!");
//			break;
		case SUBSCRIBE:
			subscribe.forward(evt);
			break;
		case NOTIFY:
			notify.forward(evt);
			break;
		case MESSAGE:
			message.forward(evt);
			break;
		default:
			assert false;
		}
		return true;
	}
	
	enum RequestType {
		ACK, INVITE, CANCEL, BYE, PUBLISH, SUBSCRIBE, NOTIFY, MESSAGE, REGISTER
	}

}
