/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package jp.ac.naka.ec.sip.pidf;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

import javax.sip.address.URI;

import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityType;

/**
 * 
 * @author Takashi Kasuya
 *
 */
public class PIDFFactoryImpl implements PIDFFactory {

	private EntityContainer con;
	//private static Date date;
	private static SimpleDateFormat format1;
	private static SimpleDateFormat format2;
	private static TimeZone timezone;
	private static Calendar cal;
	
	// RFC3339 Format UTCdl
	private final static String pattern1 = "yyyy-MM-DD";
	private final static String pattern2 =	"kk:mm:ss";
	
	private final static String zone = "Europe/London";
	
	static {
		format1= new SimpleDateFormat(pattern1);
		format2 = new SimpleDateFormat(pattern2);
		timezone = TimeZone.getTimeZone(zone);
		cal = Calendar.getInstance(timezone);
	}
	
	/**
	 * 
	 * @param con
	 */
	public PIDFFactoryImpl(EntityContainer con) {
		this.con = con;
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.sip.pidf.PIDFFactory#createPIDF()
	 */
	public PIDFData createPIDF() {
		URI uri = con.getURI();
		PIDFData data = new PIDFData(uri);
		data.setName(con.getName());
		
		if (con.getLocation() != null) 
			data.setLocation(con.getLocation());
		List<Tuple> tuples = createTuples();
		for (Tuple tuple:tuples) {
			data.addTuple(tuple);
		}
		return data;
	}
	
	/**
	 * 
	 * @return
	 */
	private List<Tuple> createTuples () {
		Set<Entity> entities = con.getEntities();
		List<Tuple> tuples = new ArrayList<Tuple>();
		 
		boolean alive = (con.isAlive() && ((EntityContainerImpl)con).isRunning()) ? true : false;
		alive = con.isLocal() | alive;
		for (Entity entity: entities) {
			/*
			if (!entity.isLocal()) {
				continue;
			}*/
			Tuple tuple = getTuple(entity);
			tuple.setAlive(alive);
			tuples.add(tuple);
			entity.setTupleId(tuple.id);
		}
		return tuples;
	}

	private Tuple getTuple(Entity e) {
		//System.out.println(e.getName() + " : " + e);
		Date date = cal.getTime();
		Tuple tuple = new Tuple ();
		tuple.contact = e.getURI();
		tuple.id = e.getName();
		
		// EntityType̐ݒ
		EntityType ee = e.getEntityType();
		tuple.putExtension("type", ee.toString());
		tuple.putExtension("name", e.getName());
		tuple.putExtension("uri", e.getURI().toString());
		tuple.addNote(e.getDescription());
		float priority = e.getPriority();
		if (priority != 100f) {
			tuple.setPriority(priority);
		}
		//tuple.status = ;
		tuple.timestamp = format1.format(date) + "T" + format2.format(date) + "Z";
		return tuple;
	}
	
	/*
	public static void main(String[] args) {
		Entity e = new EntityImpl("test");
		PIDFFactoryImpl fac = new PIDFFactoryImpl(null);
		Tuple t = fac.getTuple(e);
		System.out.println(t.toString());
	}*/
}
