/*
 * Copyright (c) 2006 Ben Chappell (bwchappell@gmail.com) All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *   
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *    
 * - Redistribution in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *   
 * The names of Ben Chappell, Sun Microsystems, Inc. or the names of
 * contributors may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *    
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,
 * INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. BEN CHAPPELL,
 * SUN MICROSYSTEMS, INC. ("SUN"), AND SUN'S LICENSORS SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL BEN
 * CHAPPELL, SUN, OR SUN'S LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT 
 * OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,
 * ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF BEN
 * CHAPPELL OR SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *   
 * You acknowledge that this software is not designed or intended for use
 * in the design, construction, operation or maintenance of any nuclear
 * facility.
 */

package contents;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ParticleWindow extends JFrame {

	// For the engine
	private Engine engine;

	private GLComponent glComponent;

	private Integer numParticles;
	private Thread th;
	
	public ParticleWindow() {
		super("Particle Engine");

		Dimension d = getToolkit().getScreenSize();

		buildFrame(d);
		initComponents();
		th = new Thread () {
			public void run () {
				while (true) {
					engine.removeParticle();
					try {
						sleep (50);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		};
		th.start();
		setVisible(true);
	}

	private void buildFrame(Dimension d) {
		// Nicely center the window on the screen
		int width = 800;
		int x = (int) (d.getWidth() / 2) - (int) (width / 2);

		int height = 800;
		int y = (int) (d.getHeight() / 2) - (int) (height / 2);

		setBounds(x, y, width, height);
		setResizable(false);
		getContentPane().setLayout(new GridBagLayout());
		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
	}

	private void initComponents() {

		// Engine components
		numParticles = new Integer(1000);
		engine = new Engine(numParticles.intValue(), "particle.jpg");
		glComponent = new GLComponent(60, new RGBA(0.0f, 0.0f, 0.0f, 1.0f),
				new RGBA(0.0f, 0.0f, 0.0f, 1.0f), engine);
			JPanel glPanel = new JPanel(new BorderLayout());
		glPanel.setPreferredSize(new Dimension(getBounds().width - 10,
				(int) getBounds().height * 3 / 4));
		glPanel.add(glComponent);

		GridBagConstraints constraints = new GridBagConstraints();
		constraints.weightx = constraints.weighty = 1.0d;
		constraints.fill = GridBagConstraints.BOTH;

		constraints.gridx = 0;
		constraints.gridy = 0;
		glPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		getContentPane().add(glPanel, constraints);
	}

	public static void main(String[] args) {
		new ParticleWindow();
	}

	public void changeValue(int num) {
		if (num > 0) {
			for (int i = 0; i < num; i++)
				engine.addParticle();
		} else {
			for (int i = 0; i > num; i--)
				engine.removeParticle();
		}

	}

	public void reset() {
		engine.reset();
	}
}
