/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.text.ParseException;
import java.util.StringTokenizer;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.sensor.SensorData;
import jp.ac.naka.ec.sensor.SensorDataImpl;

public class EntityInformation {
    private String serviceName;
    private String serviceType;
    private String uri;
    private String description = "";
    private SensorData[] sensors;
    private Location location;

    public EntityInformation() {
    }

    public EntityInformation(Entity entity) {
        this.setServiceType(entity.getEntityType().toString());
        this.setServiceName(entity.getName());
        this.setUri(entity.getURI().toString());
        this.setDescription(entity.getDescription());
        this.setLocation(entity.getLocation());
        this.setSensors(entity.getSensors());
    }

    public EntityInformation(String str) throws ParseException {
        StringTokenizer stToken = new StringTokenizer(str);
        this.uri = stToken.nextToken(",");
        this.serviceType = stToken.nextToken(",");
        if (stToken.hasMoreTokens()) {
            this.setDescription(this.description);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUri(String uri) {
        this.uri = uri.toString();
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return String.valueOf(this.uri.toString()) + "," + this.serviceType + "," + this.description;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String type) {
        this.serviceType = type;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>\r\n<eiml>\r\n");
        if (this.serviceName != null) {
            sb.append("\t<service name=\"");
            sb.append(this.serviceName);
            sb.append("\" uri=\"");
            sb.append(this.uri);
            sb.append("\" type=\"");
            sb.append(this.serviceType);
            sb.append("\">\r\n");
        } else {
            sb.append("\t<service uri=\"");
            sb.append(this.uri);
            sb.append("\" type=\"");
            sb.append(this.serviceType);
            sb.append("\">\r\n");
        }
        if (this.location != null) {
            sb.append(this.location.toXML("\t\t"));
        }
        if (this.description != null) {
            sb.append("\t\t<description>");
            sb.append(this.description);
            sb.append("</description>\r\n");
        } else {
            sb.append("\t\t<description />\r\n");
        }
        if (this.sensors.length != 0) {
            SensorData[] sensorDataArray = this.sensors;
            int n = 0;
            int n2 = sensorDataArray.length;
            while (n < n2) {
                SensorData sensor = sensorDataArray[n];
                String padding = "\t\t";
                sb.append(sensor.toXML(padding));
                ++n;
            }
        } else {
            sb.append("\t\t<sensor />\r\n");
        }
        sb.append("\t</service>\r\n");
        sb.append("</eiml>");
        return sb.toString();
    }

    public String toYAML() {
        return null;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public SensorData[] getSensors() {
        return this.sensors;
    }

    public void setSensors(SensorData[] sensors) {
        this.sensors = sensors;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public static void main(String[] args) throws ParseException {
        EntityImpl entity = new EntityImpl("sip:kasuya@localhost:5060");
        entity.setLocation(new Location("hoge", "22", "30"));
        entity.setDescrpition("hogehoge");
        SensorDataImpl s = new SensorDataImpl();
        s.setName("hoge");
        s.setDataName("moxa");
        s.setDataType(SensorData.DataType.Integer);
        s.setData("10");
        s.setLocation(new Location("hogehoge", "20.0", "30.0"));
        entity.addSensorData(s);
        entity.addSensorData(s);
        EntityInformation info = new EntityInformation(entity);
        System.out.println(info.toXML());
    }
}

