/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity.flash;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.EntityEvent;

public class FlashXMLSocketServerEntity
extends AbstractEntity
implements Runnable {
    private List<FlashClient> clients = new ArrayList<FlashClient>();
    private static int port = 5555;
    private static ServerSocket server;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
    List<FlashClient> errors = new ArrayList<FlashClient>();

    static {
        try {
            server = new ServerSocket(port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init() {
        Thread th = new Thread(this);
        th.start();
    }

    public void receiveMessage(EntityEvent evt) {
        StringBuilder sb = new StringBuilder();
        sb.append("<event><data>");
        sb.append(evt.getMessage());
        sb.append("</data>");
        sb.append("<source>");
        sb.append(evt.getSource().toString());
        sb.append("</source>");
        Date currentTime_1 = new Date();
        String dateString = this.formatter.format(currentTime_1);
        sb.append("<time>");
        sb.append(dateString);
        sb.append("</time></event>");
        this.errors.clear();
        for (FlashClient fc : this.clients) {
            try {
                fc.sendMessage(sb.toString());
            }
            catch (IOException e) {
                this.errors.add(fc);
            }
        }
        for (FlashClient fc : this.errors) {
            this.clients.remove(fc);
            fc = null;
        }
    }

    public void run() {
        block11: {
            try {
                try {
                    while (true) {
                        Socket sock = server.accept();
                        FlashClient fc = new FlashClient(sock);
                        fc.start();
                        this.clients.add(fc);
                    }
                }
                catch (IOException iOException) {
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    server.close();
                    for (FlashClient fc : this.clients) {
                        fc.stopClient();
                        fc = null;
                    }
                    this.clients.clear();
                }
                catch (IOException fc) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        try {
            server.close();
            for (FlashClient fc : this.clients) {
                fc.stopClient();
                fc = null;
            }
            this.clients.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void dispatchEvent(String str) {
        this.sendMessage(str);
    }

    public static void main(String[] args) {
        try {
            new FlashXMLSocketServerEntity().init();
            Thread.sleep(Integer.MAX_VALUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FlashClient
    extends Thread {
        BufferedReader in = null;
        PrintWriter out = null;
        Socket sock;

        public FlashClient(Socket sock) throws IOException {
            this.sock = sock;
            this.in = new BufferedReader(new InputStreamReader(sock.getInputStream(), "UTF8"));
            this.out = new PrintWriter(new OutputStreamWriter(sock.getOutputStream(), "UTF8"));
        }

        public InetAddress getInetAddress() {
            return this.sock.getInetAddress();
        }

        public void sendMessage(String msg) throws IOException {
            this.out.print(String.valueOf(msg) + "\u0000");
            if (this.out.checkError()) {
                throw new IOException();
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block8: {
                try {
                    char[] c = new char[1];
                    while (this.in.read(c, 0, 1) != -1) {
                        StringBuilder sb = new StringBuilder(4096);
                        while (c[0] != '\u0000') {
                            sb.append(c[0]);
                            this.in.read(c, 0, 1);
                        }
                        String str = new String(sb.toString().getBytes(), "SJIS");
                        if (str.equals("<policy-file-request/>")) {
                            this.sendMessage("<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"5555\" /></cross-domain-policy>");
                            this.stopClient();
                            return;
                        }
                        System.out.println("Message : " + str);
                        if (str == null) continue;
                        FlashXMLSocketServerEntity.this.dispatchEvent(str);
                    }
                }
                catch (Throwable throwable) {
                    this.stopClient();
                    throw throwable;
                }
                {
                    catch (IOException iOException) {
                        break block8;
                        break;
                    }
                }
                this.stopClient();
                return;
            }
            this.stopClient();
        }

        private void stopClient() {
            this.interrupt();
        }
    }
}

