/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity.test;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.sensor.SensorData;
import jp.ac.naka.ec.sensor.SensorDataImpl;

public class SerialInterfaceEntity
extends AbstractEntity
implements SerialPortEventListener {
    String commPort = "COM3";
    int baud_rate = 9600;
    private OutputStream out;
    private BufferedReader comReader;
    SensorData sensor;

    public void init() {
        this.addKeyword("sensor");
        try {
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.commPort);
            if (portIdentifier.isCurrentlyOwned()) {
                return;
            }
            CommPort commPort = portIdentifier.open(this.getClass().getName(), 3000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = (SerialPort)commPort;
                serialPort.setSerialPortParams(this.baud_rate, 8, 1, 0);
                serialPort.addEventListener((SerialPortEventListener)this);
                serialPort.notifyOnDataAvailable(true);
                InputStream in = serialPort.getInputStream();
                this.out = serialPort.getOutputStream();
                this.comReader = new BufferedReader(new InputStreamReader(in));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sensor = new SensorDataImpl();
        this.sensor.setName("Moxa");
        this.sensor.setDataName("toggle");
        this.sensor.setDataType(SensorData.DataType.Float);
        this.sensor.setMeasure("");
        this.setTTL(10L);
        this.addSensorData(this.sensor);
    }

    public void receiveMessage(EntityEvent e) {
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                String buffer = null;
                try {
                    while (this.comReader.ready()) {
                        buffer = this.comReader.readLine();
                        int index = buffer.indexOf(":");
                        String value = buffer.substring(index + 1);
                        this.sensor.setData(value);
                        this.sendMessage(this.sensor.getData().toString());
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

