/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaException;
import javax.media.MediaLocator;
import javax.media.NoProcessorException;
import javax.media.NotRealizedError;
import javax.media.Processor;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.swing.JFrame;

public class AudioTransmitter {
    private String url;
    private String media = null;
    private int port;
    private DataSink d;
    private AudioFormat format;
    public static int rtp_bit = 8;
    private Processor p = null;
    private long waiting_time = 10000L;

    public AudioTransmitter(String dist_url, int port) throws MediaException {
        this(null, dist_url, port, new AudioFormat("gsm/rtp", 8000.0, 8, 1));
    }

    public AudioTransmitter(String dist_url, int port, AudioFormat format) throws MediaException {
        this(null, dist_url, port, format);
    }

    public AudioTransmitter(String media, String dist_url, int port) throws MediaException {
        this(media, dist_url, port, new AudioFormat("gsm/rtp", 8000.0, 8, 1));
    }

    public AudioTransmitter(String media, String dist_url, int port, AudioFormat format) throws MediaException {
        this.url = dist_url;
        this.port = port;
        if (media != null || media != "") {
            this.media = media;
        }
        this.format = format;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws MediaException {
        Object devices;
        MediaLocator locator = null;
        if (this.media == null) {
            AudioFormat format = new AudioFormat("LINEAR", 8000.0, 8, 1);
            devices = CaptureDeviceManager.getDeviceList((Format)format);
            CaptureDeviceInfo di = null;
            if (((Vector)devices).isEmpty()) {
                throw new MediaException("There is no available CaptureDevice.");
            }
            di = (CaptureDeviceInfo)((Vector)devices).elementAt(0);
            locator = di.getLocator();
        } else {
            locator = new MediaLocator(this.media);
        }
        try {
            this.p = Manager.createProcessor((MediaLocator)locator);
        }
        catch (IOException e) {
            System.exit(-1);
        }
        catch (NoProcessorException e) {
            System.exit(-1);
        }
        WaitingListener listener = new WaitingListener();
        this.p.addControllerListener((ControllerListener)listener);
        this.p.configure();
        devices = listener;
        synchronized (devices) {
            listener.waitForEvent(180);
        }
        this.p.setContentDescriptor(new ContentDescriptor("raw"));
        TrackControl[] track = this.p.getTrackControls();
        boolean encodingOk = false;
        int i2 = 0;
        while (i2 < track.length) {
            if (!encodingOk && track[i2] instanceof FormatControl) {
                TrackControl control = track[i2];
                if (control.setFormat((Format)this.format) == null) {
                    track[i2].setEnabled(false);
                } else {
                    encodingOk = true;
                }
            } else {
                track[i2].setEnabled(false);
            }
            ++i2;
        }
        if (encodingOk) {
            this.p.realize();
            WaitingListener i2 = listener;
            synchronized (i2) {
                listener.waitForEvent(300);
            }
            DataSource ds = null;
            try {
                ds = this.p.getDataOutput();
            }
            catch (NotRealizedError e) {
                e.printStackTrace();
                System.exit(-1);
            }
            try {
                MediaLocator ml = new MediaLocator("rtp://" + this.url + ":" + this.port + "/audio/1");
                this.d = Manager.createDataSink((DataSource)ds, (MediaLocator)ml);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void play() throws SecurityException, IOException {
        this.d.open();
        this.d.start();
        this.p.start();
    }

    public void close() {
        if (this.d == null || this.p == null) {
            throw new NullPointerException("\u307e\u3060\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        this.p.close();
        this.d.close();
    }

    public boolean isPlaying() {
        if (this.p == null || this.d == null) {
            return false;
        }
        return this.p.getState() == 600;
    }

    public Component getControlPanelComponent() {
        if (this.p != null) {
            return this.p.getControlPanelComponent();
        }
        throw new NullPointerException("Player\u304c\u4f5c\u3089\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public static void main(String[] args) throws Exception {
        try {
            AudioTransmitter at = new AudioTransmitter("192.168.0.12", 22224, new AudioFormat("ULAW/rtp", 8000.0, 8, 1));
            at.play();
            JFrame jf = new JFrame();
            jf.add(at.getControlPanelComponent());
            jf.setVisible(true);
            jf.pack();
            jf.setDefaultCloseOperation(3);
            System.out.print(at.isPlaying());
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class WaitingListener
    implements ControllerListener {
        Thread th;
        int state;
        int previous;

        WaitingListener() {
        }

        public void waitForEvent(final int state) {
            this.state = state;
            this.th = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (WaitingListener.this.previous < state) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            this.th.start();
            try {
                this.th.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent evt) {
            Processor p = (Processor)evt.getSourceController();
            this.previous = p.getState();
            if (this.th == null) {
                return;
            }
            if (p.getState() >= this.state) {
                Thread thread = this.th;
                synchronized (thread) {
                    this.th.notifyAll();
                }
            }
        }
    }
}

