/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.SipURI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import jp.ac.naka.ec.sip.pidf.PIDFParserImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

class MessageDelegate
implements MethodDelegate {
    private static Log logger = LogFactory.getLog(MessageDelegate.class);
    PIDFParserImpl parser = PIDFParserImpl.getInatance();
    private static SipCore core;
    private static EntityContainer container;

    public MessageDelegate() throws ParserConfigurationException, SAXException {
        core = SipCore.getInstance();
        container = EntityContainerImpl.getInstance();
    }

    public boolean forward(RequestEvent evt) {
        Request req = evt.getRequest();
        byte[] content = req.getRawContent();
        ToHeader to = (ToHeader)req.getHeader("To");
        SipURI toUri = (SipURI)to.getAddress().getURI();
        FromHeader from = (FromHeader)req.getHeader("From");
        SipURI fromUri = (SipURI)from.getAddress().getURI();
        ContentTypeHeader content_type = (ContentTypeHeader)req.getHeader("Content-Type");
        try {
            EntityImpl source = new EntityImpl(fromUri);
            source.setLocal(false);
            AbstractEntity target = (AbstractEntity)container.getEntity(toUri.toString());
            if (target == null) {
                throw new NullPointerException(toUri + " is null!");
            }
            String message = new String(content, "UTF-8");
            EntityEvent e = null;
            if (!content_type.getContentType().equals("text") || !content_type.getContentSubType().equals("plain")) {
                throw new IllegalArgumentException("Can not handle ContentType :" + content_type);
            }
            e = new EntityEvent(message, (EntityListener)target, (Entity)source);
            core.sendResponse(200, req);
            target.handleEvent(e);
        }
        catch (Exception e) {
            logger.warn((Object)"Error occures while processing SIP Message :", (Throwable)e);
            return false;
        }
        return true;
    }
}

