/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import jp.ac.naka.ec.sip.ByeDelegate;
import jp.ac.naka.ec.sip.InviteDelegate;
import jp.ac.naka.ec.sip.MessageDelegate;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.NotifyDelegate;
import jp.ac.naka.ec.sip.SubscribeDelegate;

class RequestDelegate
implements MethodDelegate {
    private InviteDelegate invite;
    private SubscribeDelegate subscribe;
    private NotifyDelegate notify;
    private MessageDelegate message;
    private ByeDelegate bye;

    public RequestDelegate() {
        try {
            this.subscribe = new SubscribeDelegate();
            this.notify = new NotifyDelegate();
            this.message = new MessageDelegate();
            this.invite = new InviteDelegate();
            this.bye = new ByeDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean forward(RequestEvent evt) {
        RequestType temp = RequestType.valueOf(evt.getRequest().getMethod());
        switch (temp) {
            case ACK: {
                break;
            }
            case REGISTER: {
                break;
            }
            case INVITE: {
                this.invite.forward(evt);
                break;
            }
            case CANCEL: {
                break;
            }
            case BYE: {
                this.bye.forward(evt);
                break;
            }
            case PUBLISH: {
                throw new UnsupportedOperationException("PUBLISH is not implemented!");
            }
            case SUBSCRIBE: {
                this.subscribe.forward(evt);
                break;
            }
            case NOTIFY: {
                this.notify.forward(evt);
                break;
            }
            case MESSAGE: {
                this.message.forward(evt);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestType {
        ACK,
        INVITE,
        CANCEL,
        BYE,
        PUBLISH,
        SUBSCRIBE,
        NOTIFY,
        MESSAGE,
        REGISTER;

    }
}

