/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

class SubscribeDelegate
implements MethodDelegate {
    public static int MIN_EXPIRES = 5;
    private static final String[] acceptPackages = new String[]{"presence"};
    private static Log logger = LogFactory.getLog(SubscribeDelegate.class);
    private static SipCore core;
    private static EntityContainer container;
    private Map<String, Subscriber> subscribers = new HashMap<String, Subscriber>();

    public SubscribeDelegate() throws ParserConfigurationException, SAXException {
        core = SipCore.getInstance();
        container = EntityContainerImpl.getInstance();
    }

    public boolean forward(RequestEvent evt) {
        Subscriber subscriber;
        EntityImpl source;
        Address addr;
        Entity target;
        SipURI uri;
        ExpiresHeader expires;
        block13: {
            Request req;
            block12: {
                block11: {
                    block10: {
                        req = evt.getRequest();
                        try {
                            EventHeader event = (EventHeader)req.getHeader("Event");
                            if (this.checkEventHeader(event)) break block10;
                            logger.warn((Object)"Bad event.");
                            core.sendResponse(489, req);
                            return false;
                        }
                        catch (Exception e1) {
                            logger.warn((Object)"Error while send a response.", (Throwable)e1);
                            return false;
                        }
                    }
                    expires = (ExpiresHeader)req.getHeader("Expires");
                    if (this.checkExpiresHeader(expires)) break block11;
                    logger.warn((Object)"Interval is too brief.");
                    core.sendResponse(423, req);
                    return false;
                }
                ToHeader to = (ToHeader)req.getHeader("To");
                uri = (SipURI)to.getAddress().getURI();
                target = container.getEntity(uri.toString());
                ContactHeader contact = (ContactHeader)req.getHeader("Contact");
                addr = contact.getAddress();
                SipURI sourceURI = (SipURI)contact.getAddress().getURI();
                source = new EntityImpl(sourceURI);
                if (target != null) break block12;
                core.sendResponse(404, req);
                return false;
            }
            if (this.isAuthorized(req)) break block13;
            core.sendResponse(401, req);
            return false;
        }
        EntityEvent ee = new EntityEvent(target, source, EntityEvent.EventType.SUBSCRIBE);
        ((AbstractEntity)target).handleEvent(ee);
        String uri_str = uri.toString();
        if (this.subscribers.containsKey(uri)) {
            subscriber = this.subscribers.get(uri);
            subscriber.refresh();
        } else {
            subscriber = new Subscriber(expires.getExpires(), target, source);
            this.subscribers.put(uri_str, subscriber);
            if (target instanceof AbstractEntity) {
                ((AbstractEntity)target).addSubscriber(source);
            }
        }
        core.sendResponse(200, evt, addr.getURI().toString());
        if (target instanceof AbstractEntity) {
            ((AbstractEntity)target).startNotify(source);
        }
        return true;
    }

    private boolean isAuthorized(Request req) {
        return true;
    }

    private boolean checkExpiresHeader(ExpiresHeader expires) {
        int expire = expires.getExpires();
        return expire > MIN_EXPIRES;
    }

    private boolean checkEventHeader(EventHeader header) {
        String type = header.getEventType();
        String[] stringArray = acceptPackages;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String str = stringArray[n];
            if (str.equals(type)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    class Subscriber
    implements Runnable {
        int expire;
        Entity target;
        Entity source;
        ExecutorService ex = Executors.newSingleThreadExecutor();
        Thread th;

        public Subscriber(int expire, Entity listener, Entity source) {
            this.expire = expire;
            this.source = source;
            if (listener instanceof AbstractEntity) {
                this.target = listener;
                this.ex.execute(this);
            }
        }

        public void run() {
            try {
                Thread.sleep(this.expire * 1000);
                EntityEvent evt = new EntityEvent(this.target, this.source, EntityEvent.EventType.REMOVE);
                ((AbstractEntity)this.target).handleEvent(evt);
                ((AbstractEntity)this.target).removeSubscriber(this.source);
                SubscribeDelegate.this.subscribers.remove(this.target.getURI().toString());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void refresh() {
            this.ex.shutdownNow();
            this.ex.execute(this);
        }
    }
}

