/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip.pidf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sip.address.URI;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.sip.pidf.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIDFData {
    public static final String CONTENT_TYPE = "application";
    public static final String CONTENT_SUBTYPE = "pidf+xml";
    public static final String NAME_SPACE = "urn:ietf:params:xml:ns:pidf";
    private String entryTag;
    private String message = "";
    private Location location;
    private URI entity;
    private List<Tuple> tuples = new ArrayList<Tuple>();
    private Map<String, String> extensions;
    private List<String> notes = new ArrayList<String>();

    public PIDFData() {
    }

    public PIDFData(URI entity) {
        this();
        this.entity = entity;
    }

    public void addTuple(Tuple tuple) {
        this.tuples.add(tuple);
    }

    public List<Tuple> getTuples() {
        return this.tuples;
    }

    public List<String> getNotes() {
        return this.notes;
    }

    public void addNote(String comment) {
        this.notes.add(comment);
    }

    public URI getURI() {
        return this.entity;
    }

    public void setURI(URI entity) {
        this.entity = entity;
    }

    public String getEntryTag() {
        return this.entryTag;
    }

    public void setEntryTag(String entryTag) {
        this.entryTag = entryTag;
    }

    public void putExtensions(String key, String value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, String>();
        }
        this.extensions.put(key, value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<presence xmlns=\"");
        builder.append(NAME_SPACE);
        builder.append("\" entity=\"");
        builder.append(this.entity + "\">\r\n");
        for (Tuple tuple : this.tuples) {
            builder.append("<tuple id=\"");
            builder.append(tuple.id);
            builder.append("\">");
            builder.append(tuple.toString());
            builder.append("</tuple>\r\n");
        }
        if (this.extensions != null) {
            Set<String> set = this.extensions.keySet();
            for (String key : set) {
                String value = this.extensions.get(key);
                builder.append("<" + key + ">");
                builder.append(value);
                builder.append("</" + key + ">");
                builder.append("\r\n");
            }
        }
        if (this.location != null) {
            builder.append("<location><name>");
            builder.append(this.location.getName());
            builder.append("</name><latitude>");
            builder.append(this.location.getLatitude());
            builder.append("</latitude><longitude>");
            builder.append(this.location.getLongitude());
            builder.append("</longitude></location>\r\n");
        }
        if (!this.message.equals("")) {
            builder.append("<message>");
            builder.append(this.message);
            builder.append("</message>\r\n");
        }
        for (String note : this.notes) {
            builder.append("<note>");
            builder.append(note);
            builder.append("</note>");
            builder.append("\r\n");
        }
        builder.append("</presence>");
        return builder.toString();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }
}

