/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.impl.CHTImpl;
import ow.dht.impl.DHTImpl;
import ow.id.ID;
import ow.routing.RoutingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTFactory {
    private static final Logger logger = Logger.getLogger("dht");
    private static final Class[] DHT_IMPLEMENTATIONS = new Class[]{DHTImpl.class, CHTImpl.class};
    private static final Map<String, Class<DHT>> dhtImplTable = new HashMap<String, Class<DHT>>();

    public static DHTConfiguration getDefaultConfiguration() {
        return new DHTConfiguration();
    }

    public static <V extends Serializable> DHT<V> getDHT(DHTConfiguration config) throws Exception {
        return DHTFactory.getDHT(config, (ID)null);
    }

    public static <V extends Serializable> DHT<V> getDHT(DHTConfiguration config, ID selfID) throws Exception {
        Class<DHT> clazz = dhtImplTable.get(config.getImplementationName());
        Class[] argClz = new Class[]{DHTConfiguration.class, ID.class};
        Constructor<DHT> ctor = clazz.getConstructor(argClz);
        Object[] args = new Object[]{config, selfID};
        return ctor.newInstance(args);
    }

    public static <V extends Serializable> DHT<V> getDHT(short applicationID, short applicationVersion, DHTConfiguration config) throws Exception {
        return DHTFactory.getDHT(applicationID, applicationVersion, config, null);
    }

    public static <V extends Serializable> DHT<V> getDHT(short applicationID, short applicationVersion, DHTConfiguration config, ID selfID) throws Exception {
        Class<DHT> clazz = dhtImplTable.get(config.getImplementationName());
        Class[] argClz = new Class[4];
        argClz[0] = argClz[1] = Short.TYPE;
        argClz[2] = DHTConfiguration.class;
        argClz[3] = ID.class;
        Constructor<DHT> ctor = clazz.getConstructor(argClz);
        Object[] args = new Object[]{applicationID, applicationVersion, config, selfID};
        return ctor.newInstance(args);
    }

    public static <V extends Serializable> DHT<V> getDHT(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        Class<DHT> clazz = dhtImplTable.get(config.getImplementationName());
        Class[] argClz = new Class[]{DHTConfiguration.class, RoutingService.class};
        Constructor<DHT> ctor = clazz.getConstructor(argClz);
        Object[] args = new Object[]{config, routingSvc};
        return ctor.newInstance(args);
    }

    static {
        for (Class clazz : DHT_IMPLEMENTATIONS) {
            try {
                Method getNameMethod = clazz.getDeclaredMethod("getName", new Class[0]);
                String name = (String)getNameMethod.invoke((Object)clazz, new Object[0]);
                dhtImplTable.put(name, clazz);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "The class does not have a method named getName:" + clazz);
            }
        }
    }
}

