/*
 * Decompiled with CFR 0.152.
 */
package ow.dht.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.dht.impl.DHTMessageFactory;
import ow.directory.DirectoryFactory;
import ow.directory.DirectoryProvider;
import ow.directory.DupDirectory;
import ow.directory.expiration.ExpiringDupDirectory;
import ow.directory.expiration.ExpiringValue;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingFactory;
import ow.messaging.MessagingProvider;
import ow.messaging.Signature;
import ow.messaging.Tag;
import ow.routing.CallbackOnRoute;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmFactory;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.RoutingServiceFactory;
import ow.routing.RoutingServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTImpl<V extends Serializable>
implements DHT<V> {
    static final Logger logger = Logger.getLogger("dht");
    private static final String GLOBAL_DB_NAME = "global";
    private static final String LOCAL_DB_NAME = "local";
    private DHTConfiguration config;
    private RoutingAlgorithmConfiguration algoConfig;
    private RoutingServiceConfiguration svcConfig;
    private RoutingService routingSvc;
    private IDAddressPair selfIDAddressPair;
    private MessageSender sender;
    private boolean suspended = false;
    private ExpiringDupDirectory<ID, ValueInfo<V>> globalDir;
    private DupDirectory<ID, ValueInfo<V>> localDir = null;
    private Thread republisherOnPublisher = null;
    private Thread republisherOnTargets = null;
    private ID lastKey = null;
    private RoutingResult lastRoutingResult = null;

    public static String getName() {
        return "DHT";
    }

    public DHTImpl(DHTConfiguration config, ID selfID) throws Exception {
        this(Signature.getAllAcceptingApplicationID(), Signature.getAllAcceptingApplicationVersion(), config, selfID);
    }

    public DHTImpl(short applicationID, short applicationVersion, DHTConfiguration config, ID selfID) throws Exception {
        byte[] messageSignature = Signature.getSignature(RoutingServiceFactory.getRoutingStyleID(config.getRoutingStyle()), RoutingAlgorithmFactory.getAlgorithmID(config.getRoutingAlgorithm()), applicationID, applicationVersion);
        MessagingProvider msgProvider = MessagingFactory.getProvider(config.getMessagingType(), messageSignature);
        if (config.getSelfAddress() != null) {
            msgProvider.setDefaultSelfAddress(config.getSelfAddress());
        }
        MessageReceiver receiver = msgProvider.getReceiver(msgProvider.getDefaultConfiguration(), config.getSelfPort(), config.getSelfPortRange());
        config.setSelfPort(receiver.getPort());
        RoutingAlgorithmProvider algoProvider = RoutingAlgorithmFactory.getProvider(config.getRoutingAlgorithm());
        this.algoConfig = algoProvider.getDefaultConfiguration();
        RoutingServiceProvider svcProvider = RoutingServiceFactory.getProvider(config.getRoutingStyle());
        this.svcConfig = svcProvider.getDefaultConfiguration();
        RoutingService routingSvc = svcProvider.getService(this.svcConfig, msgProvider, receiver, this.algoConfig, selfID);
        algoProvider.getAlgorithmInstance(this.algoConfig, routingSvc);
        this.init(config, routingSvc);
    }

    public DHTImpl(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        this.init(config, routingSvc);
    }

    private void init(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        this.config = config;
        this.routingSvc = routingSvc;
        this.selfIDAddressPair = this.routingSvc.getSelfIDAddressPair();
        this.sender = this.routingSvc.getMessageSender();
        File workingDirFile = new File(config.getWorkingDirectory());
        workingDirFile.mkdirs();
        DirectoryProvider dirProvider = DirectoryFactory.getProvider(config.getDirectoryType());
        this.globalDir = dirProvider.openExpiringDupDirectory(ID.class, config.getValueClass(), config.getWorkingDirectory(), GLOBAL_DB_NAME, config.getDefaultTTL(), config.getDoExpire() ? config.getExpireCheckInterval() : -1L);
        if (this.config.getDoRepublishOnPublisher()) {
            this.localDir = dirProvider.openDupDirectory(ID.class, ValueInfo.class, config.getWorkingDirectory(), LOCAL_DB_NAME);
        }
        this.prepareHandlers(this.routingSvc);
        this.prepareCallbacks(this.routingSvc);
        if (config.getRepublishInterval() > 0L) {
            if (this.config.getDoRepublishOnPublisher()) {
                this.republisherOnPublisher = new Thread(new Republisher(this.localDir));
                this.republisherOnPublisher.setName("Republisher on " + this.selfIDAddressPair.getAddress());
                this.republisherOnPublisher.setDaemon(true);
                this.republisherOnPublisher.start();
            }
            if (this.config.getDoRepublishOnTargets()) {
                this.republisherOnTargets = new Thread(new Republisher(this.globalDir));
                this.republisherOnTargets.setName("Republisher on " + this.selfIDAddressPair.getAddress());
                this.republisherOnTargets.setDaemon(true);
                this.republisherOnTargets.start();
            }
        }
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort, int defaultPort) throws UnknownHostException {
        MessagingAddress addr = this.routingSvc.getMessagingProvider().getMessagingAddress(hostAndPort, defaultPort);
        this.joinOverlay(addr);
        return addr;
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort) throws UnknownHostException {
        MessagingAddress addr = this.routingSvc.getMessagingProvider().getMessagingAddress(hostAndPort);
        this.joinOverlay(addr);
        return addr;
    }

    private void joinOverlay(MessagingAddress addr) {
        RoutingResult routingRes;
        logger.log(Level.INFO, "DHTImpl#joinOverlay: " + addr);
        this.lastKey = this.selfIDAddressPair.getID();
        this.lastRoutingResult = routingRes = this.routingSvc.join(addr);
        int nodeCount = this.config.getNumNodesAskedToDelegate();
        IDAddressPair[] neighbors = routingRes.getNeighbors();
        if (nodeCount > 0 && neighbors != null) {
            int neighborIndex = 0;
            while (nodeCount > 0 && neighborIndex < neighbors.length) {
                IDAddressPair delegatingNode;
                if (this.selfIDAddressPair.equals(delegatingNode = neighbors[neighborIndex++])) continue;
                Message request = DHTMessageFactory.getGetNearToMessage(this.selfIDAddressPair, this.selfIDAddressPair.getID());
                try {
                    Message reply = this.sender.sendAndReceive(delegatingNode.getAddress(), request);
                    Serializable[] contents = reply.getContents();
                    Map valueMap = (Map)((Object)contents[0]);
                    if (valueMap != null) {
                        for (Map.Entry entry : valueMap.entrySet()) {
                            ID key = (ID)entry.getKey();
                            Set valSet = (Set)entry.getValue();
                            for (ValueInfo val : valSet) {
                                try {
                                    this.globalDir.put(key, val, val.getTTL());
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "failed to send: " + delegatingNode.getAddress());
                }
                --nodeCount;
            }
        }
    }

    @Override
    public void clearRoutingTable() {
        this.routingSvc.leave();
        this.lastKey = null;
        this.lastRoutingResult = null;
    }

    @Override
    public void clearDHTState() {
        this.globalDir.clear();
        if (this.localDir != null) {
            this.localDir.clear();
        }
    }

    public Set<ValueInfo<V>> put(ID key, V value) throws Exception {
        return this.put(key, value, this.config.getDefaultTTL(), null);
    }

    public Set<ValueInfo<V>> put(ID key, V value, ByteArray hashedSecret) throws Exception {
        return this.put(key, value, this.config.getDefaultTTL(), hashedSecret);
    }

    @Override
    public Set<ValueInfo<V>> put(ID key, V value, long ttl) throws Exception {
        return this.put(key, value, ttl, null);
    }

    @Override
    public Set<ValueInfo<V>> put(ID key, V value, long ttl, ByteArray hashedSecret) throws Exception {
        if (this.localDir != null) {
            this.localDir.put(key, new ValueInfo<V>(value, ttl, hashedSecret));
        }
        return this.publish(key, value, ttl, hashedSecret, true);
    }

    @Override
    public Set<ValueInfo<V>> get(ID key) {
        IDAddressPair[] neighbors;
        Serializable[] args = new Serializable[]{key};
        Serializable[] callbackResultContainer = new Serializable[1];
        RoutingResult routingRes = this.routingSvc.invokeCallbacksOnRoute(key, this.config.getNumTimesGets(), callbackResultContainer, null, -1, args);
        this.lastKey = key;
        this.lastRoutingResult = routingRes;
        Set resultSet = (Set)((Object)callbackResultContainer[0]);
        int numTimesGets = this.config.getNumTimesGets() - 1;
        if (numTimesGets > 0 && (neighbors = routingRes.getNeighbors()) != null && neighbors.length > 1) {
            Message request = DHTMessageFactory.getGetMessage(this.selfIDAddressPair, key);
            for (int i = 1; i < neighbors.length; ++i) {
                MessagingAddress tgt = neighbors[i].getAddress();
                try {
                    Message reply = this.sender.sendAndReceive(tgt, request);
                    Serializable[] contents = reply.getContents();
                    Set s = (Set)((Object)contents[0]);
                    if (s != null) {
                        if (resultSet == null) {
                            resultSet = s;
                        } else {
                            resultSet.addAll(s);
                        }
                    }
                    if (--numTimesGets > 0) continue;
                    break;
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "failed to send: " + tgt);
                }
            }
        }
        return resultSet;
    }

    @Override
    public ValueInfo<V> remove(ID key, V value, ByteArray hashedSecret) {
        return this.remove(key, value, null, hashedSecret);
    }

    @Override
    public ValueInfo<V> remove(ID key, ID valueHash, ByteArray hashedSecret) {
        return this.remove(key, null, valueHash, hashedSecret);
    }

    @Override
    public Set<ValueInfo<V>> remove(ID key, ByteArray hashedSecret) {
        return this.requestRemove(key, null, null, hashedSecret, true);
    }

    public ValueInfo<V> remove(ID key, V value, ID valueHash, ByteArray hashedSecret) {
        Set<ValueInfo<V>> s = this.requestRemove(key, value, valueHash, hashedSecret, true);
        if (s != null && !s.isEmpty()) {
            Object[] array = s.toArray();
            return (ValueInfo)array[0];
        }
        return null;
    }

    private Set<ValueInfo<V>> requestRemove(ID key, V value, ID valueHash, ByteArray hashedSecret, boolean preserveLastRoute) {
        Message request = DHTMessageFactory.getRemoveMessage(this.selfIDAddressPair, key, value, valueHash, hashedSecret);
        boolean sent = false;
        HashSet<ValueInfo<V>> existedValues = new HashSet<ValueInfo<V>>();
        RoutingResult routingRes = this.routingSvc.routeToRootNode(key, this.config.getNumReplica());
        IDAddressPair[] neighbors = routingRes.getNeighbors();
        for (int i = 0; i < neighbors.length; ++i) {
            Serializable[] contents;
            IDAddressPair target = neighbors[i];
            if (target == null) continue;
            Message reply = null;
            try {
                reply = this.sender.sendAndReceive(target.getAddress(), request);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "failed to send: " + target.getAddress());
                continue;
            }
            if (reply.getTag() != Tag.DHT_REPLY.getNumber()) continue;
            logger.log(Level.INFO, "remove succeeded: " + value + " on " + target.getAddress());
            if (!sent && (contents = reply.getContents())[0] != null) {
                existedValues.addAll((Set)((Object)contents[0]));
            }
            sent = true;
        }
        if (preserveLastRoute) {
            this.lastKey = key;
            this.lastRoutingResult = routingRes;
        }
        if (!sent) {
            logger.log(Level.WARNING, "All remove requests failed.");
        }
        return existedValues.size() > 0 ? existedValues : null;
    }

    @Override
    public synchronized void stop() {
        logger.log(Level.INFO, "DHT#stop() called.");
        if (this.republisherOnTargets != null) {
            this.republisherOnTargets.interrupt();
            this.republisherOnTargets = null;
        }
        if (this.republisherOnPublisher != null) {
            this.republisherOnPublisher.interrupt();
            this.republisherOnPublisher = null;
        }
        if (this.routingSvc != null) {
            this.routingSvc.stop();
            this.routingSvc = null;
        }
        if (this.localDir != null) {
            this.localDir.close();
            this.localDir = null;
        }
        if (this.globalDir != null) {
            this.globalDir.close();
            this.globalDir = null;
        }
    }

    @Override
    public synchronized void suspend() {
        this.routingSvc.suspend();
        this.suspended = true;
    }

    @Override
    public synchronized void resume() {
        this.routingSvc.resume();
        this.suspended = false;
        this.notifyAll();
    }

    @Override
    public Set<ID> getLocalKeys() {
        if (this.localDir == null) {
            return null;
        }
        return this.localDir.keySet();
    }

    @Override
    public Set<ValueInfo<V>> getLocalValues(ID key) {
        if (this.localDir == null) {
            return null;
        }
        Set<ValueInfo<V>> ret = null;
        try {
            ret = this.localDir.get(key);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An Exception thrown when retrieve from the localDir.", e);
            return null;
        }
        return ret;
    }

    @Override
    public Set<ID> getGlobalKeys() {
        return this.globalDir.keySet();
    }

    @Override
    public Set<ValueInfo<V>> getGlobalValues(ID key) {
        Set<ExpiringValue<ValueInfo<V>>> expiringValues = null;
        try {
            expiringValues = this.globalDir.getExpiringValue(key);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An Exception thrown when retrieve from the globalDir.", e);
        }
        HashSet<ValueInfo<V>> ret = new HashSet<ValueInfo<V>>();
        for (ExpiringValue<ValueInfo<V>> entry : expiringValues) {
            ValueInfo<V> v = entry.getValue();
            long ttl = entry.getExpiringTime() - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 0L;
            }
            v.setTTL(ttl);
            ret.add(v);
        }
        return ret;
    }

    @Override
    public RoutingService getRoutingService() {
        return this.routingSvc;
    }

    @Override
    public DHTConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public RoutingAlgorithmConfiguration getRoutingAlgorithmConfiguration() {
        return this.algoConfig;
    }

    @Override
    public IDAddressPair getSelfIDAddressPair() {
        return this.selfIDAddressPair;
    }

    @Override
    public void setStatCollectorAddress(String host, int port) throws UnknownHostException {
        MessagingAddress addr = this.routingSvc.getMessagingProvider().getMessagingAddress(host, port);
        this.routingSvc.setStatCollectorAddress(addr);
    }

    @Override
    public String getLastKeyString() {
        if (this.lastKey == null) {
            return "null";
        }
        return this.lastKey.toString();
    }

    @Override
    public RoutingResult getLastRoutingResult() {
        return this.lastRoutingResult;
    }

    @Override
    public String getRoutingTableString() {
        return this.routingSvc.getRoutingAlgorithm().getRoutingTableString();
    }

    private Set<ValueInfo<V>> publish(ID key, V value, long ttl, ByteArray hashedSecret, boolean preserveLastRoute) throws IOException {
        Serializable[] values = new Serializable[]{value};
        Message request = DHTMessageFactory.getPutMessage(this.selfIDAddressPair, key, values, ttl, hashedSecret);
        boolean sent = false;
        Set existedValues = null;
        RoutingResult routingRes = this.routingSvc.routeToRootNode(key, this.config.getNumReplica());
        IDAddressPair[] neighbors = routingRes.getNeighbors();
        for (int i = 0; i < neighbors.length; ++i) {
            IDAddressPair target = neighbors[i];
            if (target == null) continue;
            Message reply = null;
            try {
                reply = this.sender.sendAndReceive(target.getAddress(), request);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send a put message to " + target.getAddress(), e);
                continue;
            }
            if (reply.getTag() != Tag.DHT_REPLY.getNumber()) continue;
            logger.log(Level.INFO, "put succeeded: " + value + " on " + target.getAddress());
            if (!sent) {
                Serializable[] contents = reply.getContents();
                existedValues = (Set)((Object)contents[0]);
            }
            sent = true;
        }
        if (preserveLastRoute) {
            this.lastKey = key;
            this.lastRoutingResult = routingRes;
        }
        if (!sent) {
            throw new IOException("All put requests failed.");
        }
        return existedValues;
    }

    private void prepareHandlers(RoutingService routingSvc) {
        MessageHandler handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID key = (ID)contents[0];
                Serializable[] values = (Serializable[])contents[1];
                long ttl = (Long)contents[2];
                ByteArray hashedSecret = (ByteArray)contents[3];
                logger.log(Level.INFO, "A PUT message received: " + key + ", " + values);
                if (ttl > DHTImpl.this.config.getMaximumTTL()) {
                    ttl = DHTImpl.this.config.getMaximumTTL();
                } else if (ttl <= 0L) {
                    ttl = 0L;
                }
                HashSet<ValueInfo<Serializable>> existedValues = new HashSet<ValueInfo<Serializable>>();
                try {
                    for (Serializable v : values) {
                        if (v == null) continue;
                        ValueInfo<Serializable> old = DHTImpl.this.globalDir.put(key, new ValueInfo<Serializable>(v, ttl, hashedSecret), ttl);
                        existedValues.add(old);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "An Exception thrown when DupDirectory#put() called.", e);
                }
                return DHTMessageFactory.getDHTReplyMessage(DHTImpl.this.selfIDAddressPair, existedValues.isEmpty() ? null : existedValues);
            }
        };
        routingSvc.addMessageHandler(Tag.PUT.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID key = (ID)contents[0];
                Set valueSet = DHTImpl.this.getValueLocally(key);
                return DHTMessageFactory.getDHTReplyMessage(DHTImpl.this.selfIDAddressPair, valueSet);
            }
        };
        routingSvc.addMessageHandler(Tag.GET.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID key = (ID)contents[0];
                Map valueMap = DHTImpl.this.getValueLocallyNearTo(key);
                return DHTMessageFactory.getReplyNearToMessage(DHTImpl.this.selfIDAddressPair, valueMap);
            }
        };
        routingSvc.addMessageHandler(Tag.GET_NEAR_TO.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID key = (ID)contents[0];
                Serializable value = contents[1];
                ID valueHash = (ID)contents[2];
                ByteArray hashedSecret = (ByteArray)contents[3];
                logger.log(Level.INFO, "A REMOVE message received: " + key);
                HashSet<ValueInfo<Serializable>> existedValues = new HashSet<ValueInfo<Serializable>>();
                Set globalValues = null;
                if (hashedSecret == null) {
                    logger.log(Level.WARNING, "A REMOVE request with no secret.");
                    return null;
                }
                try {
                    if (value == null) {
                        Set localValues;
                        if (DHTImpl.this.localDir != null && (localValues = DHTImpl.this.localDir.get(key)) != null) {
                            for (ValueInfo valueInfo : localValues) {
                                ID h = ID.getSHA1BasedID(valueInfo.getValue().toString().getBytes(DHTImpl.this.config.getValueEncoding()));
                                if (!h.equals(valueHash) || !hashedSecret.equals(valueInfo.getSecret())) continue;
                                DHTImpl.this.localDir.remove(key, valueInfo);
                            }
                        }
                        if ((globalValues = DHTImpl.this.globalDir.getExpiringValue(key)) != null) {
                            for (ExpiringValue expiringValue : globalValues) {
                                ValueInfo v = (ValueInfo)expiringValue.getValue();
                                ID h = ID.getSHA1BasedID(v.getValue().toString().getBytes(DHTImpl.this.config.getValueEncoding()));
                                if (valueHash != null && !h.equals(valueHash) || !hashedSecret.equals(v.getSecret())) continue;
                                DHTImpl.this.globalDir.remove(key, v);
                                v.setTTL(expiringValue.getExpiringTime() - System.currentTimeMillis());
                                existedValues.add(v);
                            }
                        }
                    } else {
                        ValueInfo<Serializable> v;
                        if (DHTImpl.this.localDir != null) {
                            DHTImpl.this.localDir.remove(key, new ValueInfo<Serializable>(value, 0L, hashedSecret));
                        }
                        if ((v = DHTImpl.this.globalDir.remove(key, new ValueInfo<Serializable>(value, 0L, hashedSecret))) != null) {
                            existedValues.add(v);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "An Exception thrown by DupDirectory#remove().", e);
                }
                return DHTMessageFactory.getDHTReplyMessage(DHTImpl.this.selfIDAddressPair, existedValues.isEmpty() ? null : existedValues);
            }
        };
        routingSvc.addMessageHandler(Tag.REMOVE.getNumber(), handler);
    }

    private void prepareCallbacks(RoutingService routingSvc) {
        routingSvc.addCallbackOnRoute(new CallbackOnRoute(){

            public Serializable process(ID target, int tag, Serializable[] args, CallbackResultFilter filter, IDAddressPair lastHop, boolean onRootNode) {
                logger.log(Level.INFO, "A callback invoked: " + (ID)args[0]);
                ID key = (ID)args[0];
                return (Serializable)((Object)DHTImpl.this.getValueLocally(key));
            }
        });
    }

    private Set<ValueInfo<V>> getValueLocally(ID key) {
        Set<ExpiringValue<ValueInfo<V>>> globalValues = null;
        try {
            globalValues = this.globalDir.getExpiringValue(key);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An Exception thrown by DupDirectory#get().", e);
            return null;
        }
        HashSet<ValueInfo<V>> returnedValues = new HashSet<ValueInfo<V>>();
        if (globalValues != null) {
            for (ExpiringValue<ValueInfo<V>> entry : globalValues) {
                ValueInfo<V> v = entry.getValue();
                long ttl = entry.getExpiringTime() - System.currentTimeMillis();
                if (ttl < 0L) {
                    ttl = 0L;
                }
                v.setTTL(ttl);
                returnedValues.add(v);
            }
        }
        return returnedValues.isEmpty() ? null : returnedValues;
    }

    private Map<ID, Set<ValueInfo<V>>> getValueLocallyNearTo(ID otherID) {
        ID selfID = this.selfIDAddressPair.getID();
        RoutingAlgorithm algo = this.routingSvc.getRoutingAlgorithm();
        HashMap<ID, Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<V>>>>>>>>>>>>>>>>> results = new HashMap<ID, Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<Set<ValueInfo<V>>>>>>>>>>>>>>>>>();
        Set<ID> keySet = this.globalDir.keySet();
        for (ID k : keySet) {
            BigInteger distanceToSelf = BigInteger.ZERO;
            BigInteger distanceToOther = BigInteger.ZERO;
            if (!k.equals(selfID)) {
                distanceToSelf = algo.distance(selfID, k);
            }
            if (!k.equals(otherID)) {
                distanceToOther = algo.distance(otherID, k);
            }
            if (distanceToOther.compareTo(distanceToSelf) > 0) continue;
            Set<ValueInfo<V>> v = null;
            try {
                v = this.globalDir.get(k);
                if (v == null) continue;
                results.put(k, v);
            }
            catch (Exception e) {}
        }
        return results.isEmpty() ? null : results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Republisher
    implements Runnable {
        Random rnd = new Random(System.currentTimeMillis());
        DupDirectory<ID, ValueInfo<V>> sourceDir;

        public Republisher(DupDirectory<ID, ValueInfo<V>> sourceDir) {
            this.sourceDir = sourceDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block7: while (true) {
                    long interval = DHTImpl.this.config.getRepublishInterval();
                    double playRatio = DHTImpl.this.config.getRepublishIntervalPlayRatio();
                    double intervalRatio = 1.0 - playRatio + playRatio * 2.0 * this.rnd.nextDouble();
                    Thread.sleep((long)((double)interval * intervalRatio));
                    while (DHTImpl.this.suspended) {
                        DHTImpl dHTImpl = DHTImpl.this;
                        synchronized (dHTImpl) {
                            DHTImpl.this.wait();
                        }
                    }
                    logger.log(Level.INFO, "Republisher woke up.");
                    Iterator i$ = this.sourceDir.entrySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block7;
                        Map.Entry entry = i$.next();
                        ValueInfo p = entry.getValue();
                        try {
                            DHTImpl.this.publish(entry.getKey(), p.getValue(), p.getTTL(), p.getSecret(), false);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "publish() failed.", e);
                        }
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Republisher interrupted and die.", e);
                return;
            }
        }
    }
}

