/*
 * Decompiled with CFR 0.152.
 */
package ow.directory;

import ow.directory.Directory;
import ow.directory.DupDirectory;
import ow.directory.expiration.ExpiringDirectory;
import ow.directory.expiration.ExpiringDupDirectory;
import ow.directory.expiration.ExpiringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryProvider {
    public abstract String getName();

    public abstract <K, V> Directory<K, V> openDirectory(Class var1, Class var2, String var3, String var4) throws Exception;

    public abstract <K, V> DupDirectory<K, V> openDupDirectory(Class var1, Class var2, String var3, String var4) throws Exception;

    public <K, V> ExpiringDirectory<K, V> openExpiringDirectory(Class typeK, Class typeV, String workingDir, String dbName, long defaultExpirationTime, long checkInterval) throws Exception {
        Directory<K, V> directory = this.openDirectory(typeK, ExpiringValue.class, workingDir, dbName);
        return new ExpiringDirectory(directory, defaultExpirationTime, checkInterval);
    }

    public <K, V> ExpiringDupDirectory<K, V> openExpiringDupDirectory(Class typeK, Class typeV, String workingDir, String dbName, long defaultExpirationTime, long checkInterval) throws Exception {
        DupDirectory<K, V> directory = this.openDupDirectory(typeK, ExpiringValue.class, workingDir, dbName);
        return new ExpiringDupDirectory(directory, defaultExpirationTime, checkInterval);
    }

    public abstract void removeDirectory(String var1, String var2) throws Exception;
}

