/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.hashmap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ow.directory.Directory;
import ow.directory.DupDirectory;
import ow.directory.hashmap.HashDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashDupDirectory<K, V>
implements DupDirectory<K, V> {
    Directory<K, Map<V, V>> dir;

    HashDupDirectory(Class typeK, Class typeV, String workingDir, String dbName, String dbNameOld, long syncInterval) throws Exception {
        this.dir = new HashDirectory<K, Map<V, V>>(typeK, null, workingDir, dbName, dbNameOld, syncInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) throws Exception {
        V ret = null;
        HashDupDirectory hashDupDirectory = this;
        synchronized (hashDupDirectory) {
            Map<V, V> map = this.dir.get(key);
            if (map == null) {
                map = new HashMap<V, V>();
                this.dir.put(key, map);
            }
            ret = map.remove(value);
            map.put(value, value);
        }
        return ret;
    }

    @Override
    public Set<V> get(K key) throws Exception {
        Map<V, V> map = this.dir.get(key);
        HashSet<V> ret = null;
        if (map != null) {
            ret = new HashSet<V>();
            ret.addAll(map.keySet());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<V> remove(K key) throws Exception {
        Map<V, V> map = null;
        HashDupDirectory hashDupDirectory = this;
        synchronized (hashDupDirectory) {
            map = this.dir.remove(key);
        }
        Set<V> ret = null;
        if (map != null) {
            ret = map.keySet();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key, V value) throws Exception {
        V ret = null;
        HashDupDirectory hashDupDirectory = this;
        synchronized (hashDupDirectory) {
            Map<V, V> map = this.dir.get(key);
            if (map != null) {
                ret = map.remove(value);
                if (map.isEmpty()) {
                    this.dir.remove(key);
                }
            }
        }
        return ret;
    }

    @Override
    public Set<K> keySet() {
        return this.dir.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        HashDupDirectory hashDupDirectory = this;
        synchronized (hashDupDirectory) {
            for (Map.Entry<K, Map<V, V>> anEntry : this.dir.entrySet()) {
                for (V value : anEntry.getValue().keySet()) {
                    result.add(new HashDupDirectoryEntry(anEntry.getKey(), value));
                }
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.dir.clear();
    }

    @Override
    public void close() {
        this.dir.close();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new HashDupDirectoryIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HashDupDirectoryEntry
    implements Map.Entry<K, V> {
        K k;
        V v;
        HashDupDirectoryIterator it = null;

        HashDupDirectoryEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        HashDupDirectoryEntry(HashDupDirectoryIterator it, K k, V v) {
            this.it = it;
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V newValue) {
            Object ret = this.v;
            this.v = newValue;
            if (this.it != null) {
                this.it.remove();
                this.it.e0.getValue().put(newValue, newValue);
            }
            return ret;
        }

        public String toString() {
            return this.k + "=" + this.v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HashDupDirectoryIterator
    implements Iterator<Map.Entry<K, V>> {
        Iterator<Map.Entry<K, Map<V, V>>> it0;
        Map.Entry<K, Map<V, V>> e0;
        Iterator<V> it1;

        HashDupDirectoryIterator() {
            this.it0 = HashDupDirectory.this.dir.iterator();
            if (this.it0.hasNext()) {
                this.e0 = this.it0.next();
                this.it1 = this.e0.getValue().keySet().iterator();
            } else {
                this.it1 = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.it1 == null) {
                return false;
            }
            if (this.it1.hasNext()) {
                return true;
            }
            if (!this.it0.hasNext()) {
                return false;
            }
            this.e0 = this.it0.next();
            this.it1 = this.e0.getValue().keySet().iterator();
            return this.it1.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Object key = this.e0.getKey();
            Object value = this.it1.next();
            return new HashDupDirectoryEntry(this, key, value);
        }

        @Override
        public void remove() {
            this.it1.remove();
            if (this.e0.getValue().isEmpty()) {
                this.it0.remove();
                if (this.it0.hasNext()) {
                    this.e0 = this.it0.next();
                    this.it1 = this.e0.getValue().keySet().iterator();
                } else {
                    this.it1 = null;
                }
            }
        }
    }
}

