/*
 * Decompiled with CFR 0.152.
 */
package ow.mcast.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.mcast.Mcast;
import ow.mcast.McastCallback;
import ow.mcast.McastConfiguration;
import ow.mcast.SpanningTreeChangedCallback;
import ow.mcast.impl.GroupSet;
import ow.mcast.impl.McastMessageFactory;
import ow.mcast.impl.NeighborTable;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingFactory;
import ow.messaging.MessagingProvider;
import ow.messaging.Signature;
import ow.messaging.Tag;
import ow.routing.CallbackOnNodeFailure;
import ow.routing.CallbackOnRoute;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingAlgorithmFactory;
import ow.routing.RoutingAlgorithmProvider;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.RoutingServiceFactory;
import ow.routing.RoutingServiceProvider;
import ow.util.ExpiringMap;
import ow.util.ExpiringSet;

public final class McastImpl
implements Mcast {
    private static final Logger logger = Logger.getLogger("mcast");
    private McastConfiguration config;
    private RoutingAlgorithmConfiguration algoConfig;
    private RoutingServiceConfiguration svcConfig;
    private MessagingProvider msgProvider;
    private RoutingService routingSvc;
    private IDAddressPair selfIDAddressPair;
    private MessageReceiver receiver;
    private MessageSender sender;
    private boolean suspended = false;
    private RoutingAlgorithm routingAlgo;
    private NeighborTable neighborTable;
    protected GroupSet joinedGroupSet;
    private ExpiringSet<ID> connectRefuseGroupSet;
    private ExpiringMap<ID, MessagingAddress> connectProhibitedNeighborMap;
    private Thread refreshingThread = null;
    private Thread expiringThread = null;
    private MessagingAddress statCollectorAddress;
    List<SpanningTreeChangedCallback> spanningTreeChangedCallbacks = new ArrayList<SpanningTreeChangedCallback>(1);
    List<McastCallback> multicastCallbacks = new ArrayList<McastCallback>(1);
    private ID lastKey = null;
    private RoutingResult lastRoutingResult = null;

    public McastImpl(McastConfiguration config, ID selfID) throws Exception {
        this(Signature.getAllAcceptingApplicationID(), Signature.getAllAcceptingApplicationVersion(), config, selfID);
    }

    public McastImpl(short applicationID, short applicationVersion, McastConfiguration config, ID selfID) throws Exception {
        byte[] messageSignature = Signature.getSignature(RoutingServiceFactory.getRoutingStyleID(config.getRoutingStyle()), RoutingAlgorithmFactory.getAlgorithmID(config.getRoutingAlgorithm()), applicationID, applicationVersion);
        this.msgProvider = MessagingFactory.getProvider(config.getMessagingType(), messageSignature);
        if (config.getSelfAddress() != null) {
            this.msgProvider.setDefaultSelfAddress(config.getSelfAddress());
        }
        this.receiver = this.msgProvider.getReceiver(this.msgProvider.getDefaultConfiguration(), config.getSelfPort(), config.getSelfPortRange());
        config.setSelfPort(this.receiver.getPort());
        RoutingAlgorithmProvider algoProvider = RoutingAlgorithmFactory.getProvider(config.getRoutingAlgorithm());
        this.algoConfig = algoProvider.getDefaultConfiguration();
        RoutingServiceProvider svcProvider = RoutingServiceFactory.getProvider(config.getRoutingStyle());
        this.svcConfig = svcProvider.getDefaultConfiguration();
        RoutingService routingSvc = svcProvider.getService(this.svcConfig, this.msgProvider, this.receiver, this.algoConfig, selfID);
        this.routingAlgo = algoProvider.getAlgorithmInstance(this.algoConfig, routingSvc);
        this.init(config, routingSvc);
    }

    public McastImpl(McastConfiguration config, RoutingService routingSvc) throws Exception {
        this.init(config, routingSvc);
    }

    private void init(McastConfiguration config, RoutingService routingSvc) throws Exception {
        this.config = config;
        this.routingSvc = routingSvc;
        this.selfIDAddressPair = this.routingSvc.getSelfIDAddressPair();
        this.sender = this.routingSvc.getMessageSender();
        this.neighborTable = new NeighborTable(this, this.receiver, config.getNeighborExpiration());
        this.joinedGroupSet = new GroupSet();
        this.connectRefuseGroupSet = new ExpiringSet(config.getConnectRefuseDuration());
        this.connectProhibitedNeighborMap = new ExpiringMap(config.getConnectRefuseDuration());
        this.prepareHandlers(this.routingSvc);
        this.prepareCallbacks(this.routingSvc);
        if (config.getRefreshInterval() > 0L) {
            this.refreshingThread = new Thread(new GroupRefresher());
            this.refreshingThread.setName("Refresher");
            this.refreshingThread.setDaemon(true);
            this.refreshingThread.start();
        }
        if (config.getNeighborExpireCheckInterval() > 0L) {
            this.expiringThread = new Thread(new NeighborExpirer());
            this.expiringThread.setName("NeighborExpirer");
            this.expiringThread.setDaemon(true);
            this.expiringThread.start();
        }
    }

    public MessagingAddress joinOverlay(String hostAndPort, int defaultPort) throws UnknownHostException {
        MessagingAddress addr = this.msgProvider.getMessagingAddress(hostAndPort, defaultPort);
        this.initialize(addr);
        return addr;
    }

    public MessagingAddress joinOverlay(String hostAndPort) throws UnknownHostException {
        MessagingAddress addr = this.msgProvider.getMessagingAddress(hostAndPort);
        this.initialize(addr);
        return addr;
    }

    private void initialize(MessagingAddress addr) {
        this.lastKey = this.selfIDAddressPair.getID();
        this.lastRoutingResult = this.routingSvc.join(addr);
    }

    public void clearRoutingTable() {
        this.routingSvc.leave();
        this.lastKey = null;
        this.lastRoutingResult = null;
    }

    public void clearMcastState() {
        this.neighborTable.clear();
        this.joinedGroupSet.clear();
        this.connectRefuseGroupSet.clear();
        this.connectProhibitedNeighborMap.clear();
    }

    public void joinGroup(ID groupID) {
        this.joinedGroupSet.add(groupID);
        this.lastKey = groupID;
        this.lastRoutingResult = this.routingSvc.invokeCallbacksOnRoute(groupID, 1, null, null, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leaveGroup(ID groupID) {
        boolean ret = this.joinedGroupSet.remove(groupID);
        NeighborTable neighborTable = this.neighborTable;
        synchronized (neighborTable) {
            if (!this.neighborTable.hasChild(groupID)) {
                this.disconnectParent(groupID);
            }
            if (ret) {
                this.invokeSpanningTreeChangedCallbacks(groupID);
            }
        }
        return ret;
    }

    public void leaveAllGroups() {
        ID[] joinedGroups = this.joinedGroupSet.toArray();
        if (joinedGroups != null) {
            for (ID groupID : joinedGroups) {
                this.leaveGroup(groupID);
            }
        }
    }

    public void addSpanningTreeChangedCallback(SpanningTreeChangedCallback callback) {
        this.spanningTreeChangedCallbacks.add(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMulticastCallback(McastCallback callback) {
        List<McastCallback> list = this.multicastCallbacks;
        synchronized (list) {
            this.multicastCallbacks.add(callback);
        }
    }

    public void multicast(ID groupID, Serializable payload) {
        if (!this.joinedGroupSet.contains(groupID)) {
            this.joinGroup(groupID);
        }
        Message msg = McastMessageFactory.getMulticastMessage(this.selfIDAddressPair, groupID, this.config.getMulticastTTL(), payload);
        this.floodMessage(groupID, msg, null);
        this.invokeMulticastCallbacks(groupID, payload);
    }

    public synchronized void stop() {
        logger.log(Level.INFO, "Mcast#stop() called.");
        if (this.refreshingThread != null) {
            this.refreshingThread.interrupt();
            this.refreshingThread = null;
        }
        if (this.expiringThread != null) {
            this.expiringThread.interrupt();
            this.expiringThread = null;
        }
        if (this.routingSvc != null) {
            this.routingSvc.stop();
            this.routingSvc = null;
        }
    }

    public synchronized void suspend() {
        this.routingSvc.suspend();
        this.suspended = true;
    }

    public synchronized void resume() {
        this.routingSvc.resume();
        this.suspended = false;
        this.notifyAll();
    }

    public ID[] getJoinedGroups() {
        return this.joinedGroupSet.toArray();
    }

    public ID[] getGroupsWithSpanningTree() {
        ID[] ret = null;
        Set<ID> groups = this.neighborTable.getGroupsWithSpanningTree();
        int n = groups.size();
        if (n > 0) {
            ret = new ID[n];
            groups.toArray(ret);
        }
        return ret;
    }

    public IDAddressPair getParent(ID groupID) {
        return this.neighborTable.getParent(groupID);
    }

    public IDAddressPair[] getChildren(ID groupID) {
        return this.neighborTable.getChildren(groupID);
    }

    public RoutingService getRoutingService() {
        return this.routingSvc;
    }

    public McastConfiguration getConfiguration() {
        return this.config;
    }

    public RoutingAlgorithmConfiguration getRoutingAlgorithmConfiguration() {
        return this.algoConfig;
    }

    public IDAddressPair getSelfIDAddressPair() {
        return this.selfIDAddressPair;
    }

    public MessagingAddress getStatCollectorAddress() {
        return this.statCollectorAddress;
    }

    public void setStatCollectorAddress(String host, int port) throws UnknownHostException {
        MessagingAddress addr;
        this.statCollectorAddress = addr = this.routingSvc.getMessagingProvider().getMessagingAddress(host, port);
        this.routingSvc.setStatCollectorAddress(addr);
    }

    public String getLastKeyString() {
        if (this.lastKey == null) {
            return "null";
        }
        return this.lastKey.toString();
    }

    public RoutingResult getLastRoutingResult() {
        return this.lastRoutingResult;
    }

    public String getRoutingTableString() {
        return this.routingAlgo.getRoutingTableString();
    }

    private void prepareHandlers(RoutingService routingSvc) {
        MessageHandler handler = new MessageHandler(){

            public Message process(Message msg) {
                Message repMsg;
                Serializable[] contents = msg.getContents();
                final ID groupID = (ID)contents[0];
                final IDAddressPair from = msg.getSource();
                if (McastImpl.this.connectRefuseGroupSet.contains(groupID)) {
                    logger.log(Level.INFO, "Refuse to be connected on " + McastImpl.this.selfIDAddressPair.getAddress() + ". group ID: " + groupID);
                    repMsg = McastMessageFactory.getNackConnectMessage(McastImpl.this.selfIDAddressPair);
                } else {
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            boolean parentChanged = false;
                            NeighborTable neighborTable = McastImpl.this.neighborTable;
                            synchronized (neighborTable) {
                                IDAddressPair oldParent = McastImpl.this.neighborTable.getParent(groupID);
                                if (!from.equals(oldParent) && oldParent != null) {
                                    McastImpl.this.disconnectParent(groupID, oldParent);
                                }
                                parentChanged = McastImpl.this.neighborTable.registerParent(groupID, from);
                            }
                            if (parentChanged) {
                                McastImpl.this.invokeSpanningTreeChangedCallbacks(groupID);
                                McastImpl.this.receiver.getStatReporter().notifyStatCollectorOfConnectNodes(McastImpl.this.selfIDAddressPair, McastImpl.this.selfIDAddressPair.getID(), from.getID(), groupID.hashCode());
                            }
                        }
                    };
                    Thread t = new Thread(r);
                    t.setName("CONNECT handler");
                    t.setDaemon(true);
                    t.start();
                    repMsg = McastMessageFactory.getAckConnectMessage(McastImpl.this.selfIDAddressPair);
                }
                return repMsg;
            }
        };
        routingSvc.addMessageHandler(Tag.CONNECT.getNumber(), handler);
        handler = new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID groupID = (ID)contents[0];
                NeighborTable neighborTable = McastImpl.this.neighborTable;
                synchronized (neighborTable) {
                    boolean removed = McastImpl.this.neighborTable.removeChild(groupID, msg.getSource());
                    if (removed) {
                        McastImpl.this.invokeSpanningTreeChangedCallbacks(groupID);
                    }
                }
                return null;
            }
        };
        routingSvc.addMessageHandler(Tag.DISCONNECT.getNumber(), handler);
        handler = new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID groupID = (ID)contents[0];
                IDAddressPair source = msg.getSource();
                McastImpl.this.connectProhibitedNeighborMap.put(groupID, source.getAddress());
                NeighborTable neighborTable = McastImpl.this.neighborTable;
                synchronized (neighborTable) {
                    boolean removed = McastImpl.this.neighborTable.removeChild(groupID, source);
                    if (removed) {
                        McastImpl.this.invokeSpanningTreeChangedCallbacks(groupID);
                    }
                }
                return null;
            }
        };
        routingSvc.addMessageHandler(Tag.DISCONNECT_AND_REFUSE.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                ID groupID = (ID)contents[0];
                int ttl = (Integer)contents[1];
                Serializable payload = contents[2];
                logger.log(Level.INFO, "MULTICAST msg received. groupID: " + groupID + ", ttl: " + ttl + ", from: " + msg.getSource().getAddress());
                if (ttl > 0) {
                    IDAddressPair source = msg.getSource();
                    Message newMsg = McastMessageFactory.getMulticastMessage(McastImpl.this.selfIDAddressPair, groupID, ttl - 1, payload);
                    McastImpl.this.floodMessage(groupID, newMsg, source.getAddress());
                }
                McastImpl.this.invokeMulticastCallbacks(groupID, payload);
                return null;
            }
        };
        routingSvc.addMessageHandler(Tag.MULTICAST.getNumber(), handler);
    }

    private void prepareCallbacks(RoutingService routingSvc) {
        routingSvc.addCallbackOnRoute(new CallbackOnRoute(){

            public Serializable process(final ID groupID, int tag, Serializable[] args, CallbackResultFilter ignored, final IDAddressPair lastHop, final boolean onRootNode) {
                if (lastHop != null) {
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (onRootNode) {
                                McastImpl.this.connectRefuseGroupSet.add(groupID);
                                NeighborTable neighborTable = McastImpl.this.neighborTable;
                                synchronized (neighborTable) {
                                    McastImpl.this.disconnectAndRefuseParent(groupID);
                                }
                            }
                            McastImpl.this.connectWithChild(groupID, lastHop);
                        }
                    };
                    Thread t = new Thread(r);
                    t.setName("Connector");
                    t.setDaemon(true);
                    t.start();
                }
                return null;
            }
        });
        routingSvc.addCallbackOnNodeFailure(new CallbackOnNodeFailure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fail(IDAddressPair failedNode) {
                HashSet<ID> changedGroups = new HashSet<ID>();
                NeighborTable neighborTable = McastImpl.this.neighborTable;
                synchronized (neighborTable) {
                    changedGroups.addAll(McastImpl.this.neighborTable.removeChild(failedNode));
                    changedGroups.addAll(McastImpl.this.neighborTable.removeParent(failedNode));
                    for (ID changedGroup : changedGroups) {
                        McastImpl.this.invokeSpanningTreeChangedCallbacks(changedGroup);
                    }
                }
            }
        });
    }

    private void floodMessage(ID groupID, Message msg, MessagingAddress from) {
        IDAddressPair[] children;
        MessagingAddress parent;
        logger.log(Level.INFO, "floodMessage() called on " + this.selfIDAddressPair.getAddress() + ". from: " + from);
        IDAddressPair parentIDAddr = this.neighborTable.getParent(groupID);
        if (parentIDAddr != null && !(parent = parentIDAddr.getAddress()).equals(from)) {
            try {
                this.sender.send(parent, msg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Faild to flood to the parent.", e);
            }
        }
        if ((children = this.neighborTable.getChildren(groupID)) != null) {
            for (IDAddressPair child : children) {
                MessagingAddress childAddress = child.getAddress();
                if (childAddress.equals(from)) continue;
                try {
                    this.sender.send(childAddress, msg);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to flood to a child.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMulticastCallbacks(ID groupID, Serializable payload) {
        if (this.joinedGroupSet.contains(groupID)) {
            List<McastCallback> list = this.multicastCallbacks;
            synchronized (list) {
                for (McastCallback cb : this.multicastCallbacks) {
                    cb.received(groupID, payload);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectWithChild(ID groupID, IDAddressPair child) {
        block9: {
            MessagingAddress childAddress = child.getAddress();
            if (childAddress.equals(this.connectProhibitedNeighborMap.get(groupID))) {
                return;
            }
            Message connectMsg = McastMessageFactory.getConnectMessage(this.selfIDAddressPair, groupID);
            try {
                Message ackMsg = this.sender.sendAndReceive(childAddress, connectMsg);
                if (ackMsg.getTag() == Tag.ACK_CONNECT.getNumber()) {
                    logger.log(Level.INFO, "connectWithChild succeeded: " + child);
                    NeighborTable neighborTable = this.neighborTable;
                    synchronized (neighborTable) {
                        boolean added = this.neighborTable.registerChild(groupID, child);
                        if (added) {
                            this.invokeSpanningTreeChangedCallbacks(groupID);
                        }
                        break block9;
                    }
                }
                if (ackMsg.getTag() == Tag.NACK_CONNECT.getNumber()) {
                    this.connectProhibitedNeighborMap.put(groupID, childAddress);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to connect to " + child);
            }
        }
    }

    protected void disconnectParent(ID groupID) {
        IDAddressPair parent = this.neighborTable.getParent(groupID);
        if (parent == null) {
            return;
        }
        this.disconnectParent(groupID, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectParent(ID groupID, IDAddressPair parent) {
        NeighborTable neighborTable = this.neighborTable;
        synchronized (neighborTable) {
            this.neighborTable.removeParent(groupID, parent);
        }
        Message msg = McastMessageFactory.getDisconnectMessage(this.selfIDAddressPair, groupID);
        try {
            this.sender.send(parent.getAddress(), msg);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to disconnect from the parent: " + parent);
        }
        this.receiver.getStatReporter().notifyStatCollectorOfDisconnectNodes(this.selfIDAddressPair, this.selfIDAddressPair.getID(), parent.getID(), groupID.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAndRefuseParent(ID groupID) {
        IDAddressPair parent = this.neighborTable.getParent(groupID);
        if (parent == null) {
            return;
        }
        NeighborTable neighborTable = this.neighborTable;
        synchronized (neighborTable) {
            this.neighborTable.removeParent(groupID, parent);
            this.invokeSpanningTreeChangedCallbacks(groupID);
        }
        Message msg = McastMessageFactory.getDisconnectAndRefuseMessage(this.selfIDAddressPair, groupID);
        try {
            this.sender.send(parent.getAddress(), msg);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to disconnect_and_refuse a parent: " + parent);
        }
        this.receiver.getStatReporter().notifyStatCollectorOfDisconnectNodes(this.selfIDAddressPair, this.selfIDAddressPair.getID(), parent.getID(), groupID.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSpanningTreeChangedCallbacks(ID groupID) {
        IDAddressPair parent = this.neighborTable.getParent(groupID);
        IDAddressPair[] children = this.neighborTable.getChildren(groupID);
        List<SpanningTreeChangedCallback> list = this.spanningTreeChangedCallbacks;
        synchronized (list) {
            for (SpanningTreeChangedCallback cb : this.spanningTreeChangedCallbacks) {
                cb.topologyChanged(groupID, parent, children);
            }
        }
    }

    private class NeighborExpirer
    implements Runnable {
        private NeighborExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Object object;
                    Thread.sleep(McastImpl.this.config.getNeighborExpireCheckInterval());
                    while (McastImpl.this.suspended) {
                        object = McastImpl.this;
                        synchronized (object) {
                            McastImpl.this.wait();
                        }
                    }
                    object = McastImpl.this.neighborTable;
                    synchronized (object) {
                        Set<ID> changedGroups = McastImpl.this.neighborTable.expire();
                        for (ID groupID : changedGroups) {
                            McastImpl.this.invokeSpanningTreeChangedCallbacks(groupID);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "NeighborExpirer interrupted and die.", e);
                return;
            }
        }
    }

    private class GroupRefresher
    implements Runnable {
        private GroupRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            try {
                block5: while (true) {
                    Thread.sleep(McastImpl.access$1300(McastImpl.this).getRefreshInterval());
                    while (McastImpl.access$1400(McastImpl.this)) {
                        var1_1 = McastImpl.this;
                        synchronized (var1_1) {
                            McastImpl.this.wait();
                        }
                    }
                    groups = McastImpl.this.getJoinedGroups();
                    if (groups == null) continue;
                    arr$ = groups;
                    len$ = arr$.length;
                    i$ = 0;
                    while (true) {
                        if (i$ < len$) ** break;
                        continue block5;
                        group = arr$[i$];
                        McastImpl.this.joinGroup(group);
                        ++i$;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                McastImpl.access$400().log(Level.WARNING, "GroupRefresher interrupted and die.", e);
                return;
            }
        }
    }
}

