/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.linearwalker;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedFromSrcIDAddrPairComparator;
import ow.routing.RoutingAlgorithm;

public final class SuccessorList {
    private final IDAddressPair selfIDAddress;
    private final int maxSize;
    private final SortedSet<IDAddressPair> list;

    public SuccessorList(RoutingAlgorithm algo, IDAddressPair selfIDAddress, int maxSize) {
        this.selfIDAddress = selfIDAddress;
        this.maxSize = maxSize;
        this.list = new TreeSet<IDAddressPair>(new AlgoBasedFromSrcIDAddrPairComparator(algo, selfIDAddress.getID()));
        this.list.add(selfIDAddress);
    }

    synchronized void clear() {
        this.list.clear();
        this.list.add(this.selfIDAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IDAddressPair elem) {
        if (elem == null) {
            return;
        }
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            boolean added = this.list.add(elem);
            if (added) {
                while (this.list.size() > this.maxSize) {
                    IDAddressPair lastElem = this.list.last();
                    this.list.remove(lastElem);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(IDAddressPair[] elems) {
        if (elems == null) {
            return;
        }
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            boolean added = false;
            for (IDAddressPair elem : elems) {
                added |= this.list.add(elem);
            }
            if (added) {
                while (this.list.size() > this.maxSize) {
                    IDAddressPair lastElem = this.list.last();
                    this.list.remove(lastElem);
                }
            }
        }
    }

    public boolean contains(IDAddressPair elem) {
        if (elem == null) {
            return false;
        }
        return this.list.contains(elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IDAddressPair elem) {
        boolean ret;
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            ret = this.list.remove(elem);
            if (this.list.isEmpty()) {
                this.list.add(this.selfIDAddress);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAddressPair first() throws NoSuchElementException {
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            return this.list.first();
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAddressPair[] toArray() {
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            return this.list.toArray(new IDAddressPair[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDAddressPair[] neighbors(int maxLen) {
        IDAddressPair[] ret;
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            int len = Math.min(maxLen, this.list.size());
            ret = new IDAddressPair[len];
            ret[0] = this.selfIDAddress;
            int i = 1;
            for (IDAddressPair p : this.list) {
                if (i >= len) break;
                ret[i++] = p;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAddressPair[] closestNodes(ID target, boolean includeSelf) {
        IDAddressPair toElement = new IDAddressPair(target, null);
        ArrayList<IDAddressPair> result = new ArrayList<IDAddressPair>();
        SortedSet<IDAddressPair> sortedSet = this.list;
        synchronized (sortedSet) {
            SortedSet<IDAddressPair> smallerHalf = this.list.headSet(toElement);
            SortedSet<IDAddressPair> largerHalf = this.list.tailSet(toElement);
            if (!includeSelf) {
                smallerHalf.remove(this.selfIDAddress);
                largerHalf.remove(this.selfIDAddress);
            }
            result.addAll(largerHalf);
            if (includeSelf && !this.list.contains(this.selfIDAddress)) {
                result.add(this.selfIDAddress);
            }
            result.addAll(smallerHalf);
        }
        int len = result.size();
        IDAddressPair[] ret = new IDAddressPair[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (IDAddressPair)result.get(len - 1 - i);
        }
        return ret;
    }
}

