/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.util.Set;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.tool.dhtshell.Utility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"get"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "get <key>";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        ID key = Utility.parseID(args[0], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
        Set<ValueInfo<String>> values = dht.get(key);
        out.print("key:   " + key + "\r\n");
        if (values != null) {
            for (ValueInfo<String> v : values) {
                out.print("value: " + v.getValue() + " " + v.getTTL() / 1000L);
                ByteArray secret = v.getSecret();
                if (secret != null) {
                    out.print(" " + secret);
                }
                out.print("\r\n");
            }
        } else {
            out.print("value:\r\n");
        }
        out.flush();
        return false;
    }
}

