/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.id.ID;
import ow.tool.dhtshell.Utility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"put"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "put <key> <value> <ttl> [<secret>]";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 3) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        ID key = Utility.parseID(args[0], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
        String value = args[1];
        long ttl = (long)Integer.parseInt(args[2]) * 1000L;
        ByteArray secret = null;
        if (args.length >= 4) {
            try {
                secret = ByteArray.valueOf(args[3], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            secret = secret.hashWithSHA1();
        }
        try {
            if (secret != null) {
                dht.put(key, value, ttl, secret);
            } else {
                dht.put(key, value, ttl);
            }
        }
        catch (Exception e) {
            out.print("An exception thrown:\r\n");
            e.printStackTrace(out);
            out.flush();
        }
        return false;
    }
}

