/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import ow.dht.DHT;
import ow.id.IDAddressPair;
import ow.routing.RoutingResult;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"status"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "status";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        out.print("ID and address:\r\n ");
        out.print(dht.getSelfIDAddressPair() + "\r\n");
        out.print("Routing table:\r\n");
        String routingTableString = dht.getRoutingTableString().replaceAll("\n", "\r\n");
        out.print(routingTableString + "\r\n");
        out.print("Last key: ");
        out.print(dht.getLastKeyString() + "\r\n");
        RoutingResult routingRes = dht.getLastRoutingResult();
        if (routingRes != null) {
            out.print("Last route: ");
            out.print("[");
            for (IDAddressPair hop : routingRes.getRoute()) {
                out.print("\r\n ");
                out.print(hop);
            }
            out.print("\r\n]\r\n");
            out.print("Last neighbors: ");
            out.print("[");
            for (IDAddressPair hop : routingRes.getNeighbors()) {
                out.print("\r\n ");
                out.print(hop);
            }
            out.print("\r\n]\r\n");
        }
        out.flush();
        return false;
    }
}

