/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.messaging.MessagingFactory;
import ow.messaging.util.MessagingUtility;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.LocalControlPipeTable;
import ow.tool.emulator.OutputRedirector;
import ow.tool.emulator.RemoteControlPipeTable;
import ow.tool.emulator.commands.ArgumentsCommand;
import ow.tool.emulator.commands.ClassCommand;
import ow.tool.emulator.commands.ControlCommand;
import ow.tool.emulator.commands.HaltCommand;
import ow.tool.emulator.commands.HelpCommand;
import ow.tool.emulator.commands.IncludeCommand;
import ow.tool.emulator.commands.InvokeCommand;
import ow.tool.emulator.commands.PriorityCommand;
import ow.tool.emulator.commands.QuitCommand;
import ow.tool.emulator.commands.RemoteCommand;
import ow.tool.emulator.commands.ScheduleCommand;
import ow.tool.emulator.commands.TimeoffsetCommand;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final String COMMAND = "owemu";
    public static final int DIST_EMU_PORT = 3997;
    public static final long DIST_EMU_REMOTE_INVOCATION_WAIT = 10000L;
    public static final String ENCODING = "US-ASCII";
    public static final long DEFAULT_WAIT_MILLIS = 500L;
    public static final String RSH_COMMAND = "ssh";
    public static final String JAVA_COMMAND = "java";
    public final int DEFAULT_CONNECTION_PORT = 10010;
    private static final Class[] COMMANDS = new Class[]{ClassCommand.class, ArgumentsCommand.class, InvokeCommand.class, PriorityCommand.class, ControlCommand.class, HaltCommand.class, TimeoffsetCommand.class, ScheduleCommand.class, IncludeCommand.class, HelpCommand.class, QuitCommand.class, RemoteCommand.class};
    private OutputRedirector outputRedirector = new OutputRedirector(System.out);

    private Main() {
    }

    public static void main(String[] args) {
        Main emu = new Main();
        emu.start(args);
    }

    private static void usage() {
        System.out.print("Usage: owemu");
        System.out.println(" [-h] [-f <host list file>] [-w <str rep of host list>] [-c <connection target file>] [-s <self hostname>] [<scenario URL|file> ...]");
    }

    public void start(String[] args) {
        String optVal;
        EmulatorMode mode = EmulatorMode.NORMAL;
        RemoteControlPipeTable workerTable = null;
        String controlTargetListFilename = null;
        EmulatorContext emuContext = null;
        int initialHostID = 0;
        InetAddress selfHostAddress = null;
        try {
            selfHostAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Options opts = new Options();
        opts.addOption("h", "help", false, "print help");
        opts.addOption("f", "hostfile", true, "host file for working in master mode");
        opts.addOption("w", "workertable", true, "works in worker mode");
        opts.addOption("s", "selfipaddress", true, "self IP address (and port)");
        opts.addOption("c", "controltargetlistfile", true, "control target list file");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        if (cmd.hasOption('h')) {
            Main.usage();
            System.exit(1);
        }
        if ((optVal = cmd.getOptionValue('f')) != null) {
            try {
                workerTable = RemoteControlPipeTable.readHostFile(optVal);
            }
            catch (IOException e) {
                e.printStackTrace();
                Main.usage();
                System.exit(1);
            }
            mode = EmulatorMode.MASTER;
        }
        if ((optVal = cmd.getOptionValue('w')) != null) {
            try {
                workerTable = RemoteControlPipeTable.parseString(optVal);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                Main.usage();
                System.exit(1);
            }
            mode = EmulatorMode.WORKER;
        }
        if ((optVal = cmd.getOptionValue('s')) != null) {
            try {
                selfHostAddress = InetAddress.getByName(optVal);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        if ((optVal = cmd.getOptionValue('c')) != null) {
            controlTargetListFilename = optVal;
            mode = EmulatorMode.CONTROLLER;
        }
        args = cmd.getArgs();
        if (mode == EmulatorMode.WORKER) {
            initialHostID = workerTable.getStartHostID(selfHostAddress);
        }
        emuContext = mode == EmulatorMode.MASTER ? new EmulatorContext(System.out, initialHostID, workerTable, mode) : new EmulatorContext(System.out, initialHostID, new LocalControlPipeTable(), mode);
        if (mode == EmulatorMode.CONTROLLER) {
            try {
                this.connect(emuContext, controlTargetListFilename);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        if (mode == EmulatorMode.WORKER) {
            MessagingFactory.forceDistributedEmulator(initialHostID, workerTable);
        } else {
            MessagingFactory.forceEmulator(initialHostID);
        }
        try {
            this.parseScenario(emuContext, args);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        emuContext.joinRegisteredThread();
    }

    private void parseScenario(EmulatorContext emuContext, String[] filenames) throws IOException {
        ShellServer<EmulatorContext> shellServ = new ShellServer<EmulatorContext>(COMMANDS, emuContext, -1);
        if (filenames != null && filenames.length > 0) {
            for (int i = 0; i < filenames.length; ++i) {
                InputStream in = null;
                try {
                    in = new URL(filenames[i]).openStream();
                }
                catch (IOException e) {
                    in = new FileInputStream(filenames[i]);
                }
                BufferedReader bin = new BufferedReader(new InputStreamReader(in, ENCODING));
                this.parseScenario(emuContext, shellServ, bin, false);
                bin.close();
            }
        } else {
            BufferedReader bin = new BufferedReader(new InputStreamReader(System.in, ENCODING));
            this.parseScenario(emuContext, shellServ, bin, emuContext.getEmulatorMode() != EmulatorMode.WORKER);
        }
    }

    private void parseScenario(EmulatorContext emuContext, ShellServer<EmulatorContext> shServer, BufferedReader in, boolean interactive) {
        Shell<EmulatorContext> shell = new Shell<EmulatorContext>(in, System.out, shServer, emuContext, interactive);
        shell.run();
    }

    private void connect(EmulatorContext emuContext, String targetListFile) throws IOException {
        String aLine;
        InputStream in = null;
        try {
            in = new URL(targetListFile).openStream();
        }
        catch (IOException e) {
            in = new FileInputStream(targetListFile);
        }
        BufferedReader bin = new BufferedReader(new InputStreamReader(in, ENCODING));
        int hostID = 0;
        while ((aLine = bin.readLine()) != null) {
            MessagingUtility.HostAndPort hostPort = MessagingUtility.parseHostnameAndPort(aLine, 10010);
            System.out.println("connect to " + hostPort);
            Socket sock = new Socket(hostPort.getHostAddress(), hostPort.getPort());
            this.outputRedirector.redirect(sock.getInputStream(), "Redirector for " + hostPort);
            emuContext.setControlPipe(hostID++, new BufferedWriter(new OutputStreamWriter(sock.getOutputStream(), ENCODING)));
        }
    }
}

