/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mcastshell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.mcast.Mcast;
import ow.mcast.McastCallback;
import ow.mcast.SpanningTreeChangedCallback;
import ow.messaging.util.AccessController;
import ow.tool.emulator.EmulatorControllable;
import ow.tool.mcastshell.commands.ClearCommand;
import ow.tool.mcastshell.commands.GroupsCommand;
import ow.tool.mcastshell.commands.HaltCommand;
import ow.tool.mcastshell.commands.HelpCommand;
import ow.tool.mcastshell.commands.InitCommand;
import ow.tool.mcastshell.commands.JoinCommand;
import ow.tool.mcastshell.commands.LeaveCommand;
import ow.tool.mcastshell.commands.LeaveallCommand;
import ow.tool.mcastshell.commands.MulticastCommand;
import ow.tool.mcastshell.commands.NeighborsCommand;
import ow.tool.mcastshell.commands.QuitCommand;
import ow.tool.mcastshell.commands.ResumeCommand;
import ow.tool.mcastshell.commands.StatusCommand;
import ow.tool.mcastshell.commands.SuspendCommand;
import ow.tool.util.shellframework.Interruptible;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellServer;
import ow.tool.util.toolframework.AbstractMcastBasedTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main
extends AbstractMcastBasedTool
implements EmulatorControllable,
Interruptible {
    private static final String COMMAND = "owmcastshell";
    private static final int SHELL_PORT = -1;
    private static final Class[] COMMANDS = new Class[]{InitCommand.class, JoinCommand.class, LeaveCommand.class, LeaveallCommand.class, MulticastCommand.class, GroupsCommand.class, NeighborsCommand.class, StatusCommand.class, HelpCommand.class, QuitCommand.class, HaltCommand.class, ClearCommand.class, SuspendCommand.class, ResumeCommand.class};
    private Thread mainThread = null;

    @Override
    protected void usage(String command) {
        super.usage(command, "[-p <shell port>] [--acl <ACL file>] [-n]");
    }

    public static void main(String[] args) {
        new Main().start(args);
    }

    protected void start(String[] args) {
        try {
            this.start(0, args, new BufferedReader(new InputStreamReader(System.in, "US-ASCII")), System.out, true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start(int id, String[] args, BufferedReader in, PrintStream out) {
        this.start(id, args, in, out, false);
    }

    private void start(int id, String[] args, BufferedReader in, PrintStream out, boolean interactive) {
        int shellPort = -1;
        AccessController ac = null;
        boolean disableStdin = false;
        this.mainThread = Thread.currentThread();
        Options opts = this.getInitialOptions();
        opts.addOption("p", "port", true, "port number");
        opts.addOption("A", "acl", true, "access control list file");
        opts.addOption("n", "disablestdin", false, "disable standard input");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        String optVal = cmd.getOptionValue('p');
        if (optVal != null) {
            shellPort = Integer.parseInt(optVal);
        }
        if ((optVal = cmd.getOptionValue("A")) != null) {
            try {
                ac = new AccessController(optVal);
            }
            catch (IOException e) {
                System.err.println("An Exception thrown:");
                e.printStackTrace();
                return;
            }
        }
        if (cmd.hasOption('n')) {
            disableStdin = true;
        }
        Mcast mcast = null;
        try {
            mcast = super.initialize((short)2, (short)1, COMMAND, cmd);
        }
        catch (Exception e) {
            System.err.println("An Exception thrown:");
            e.printStackTrace();
            return;
        }
        ShellServer<Mcast> shellServ = new ShellServer<Mcast>(COMMANDS, mcast, shellPort, ac);
        shellServ.addInterruptible(this);
        Main.prepareMessageReceiver(mcast, shellServ);
        Main.prepareSpanningTreeChangeObserver(mcast, shellServ);
        if (disableStdin) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException e) {}
        } else {
            Shell<Mcast> stdioShell = new Shell<Mcast>(in, out, shellServ, mcast, interactive);
            stdioShell.run();
        }
    }

    private static void prepareMessageReceiver(Mcast mcast, final ShellServer<Mcast> shellServ) {
        McastCallback msgReceiver = new McastCallback(){

            public void received(ID groupID, Serializable payload) {
                shellServ.println("Message to group " + groupID + ":\n" + payload);
            }
        };
        mcast.addMulticastCallback(msgReceiver);
    }

    private static void prepareSpanningTreeChangeObserver(Mcast mcast, final ShellServer<Mcast> shellServ) {
        SpanningTreeChangedCallback callback = new SpanningTreeChangedCallback(){

            public void topologyChanged(ID groupID, IDAddressPair parent, IDAddressPair[] children) {
                StringBuilder sb = new StringBuilder();
                sb.append("Spanning tree changed:");
                sb.append("\n group ID: ");
                sb.append(groupID);
                sb.append("\n parent:   ");
                if (parent != null) {
                    sb.append(parent.getAddress());
                } else {
                    sb.append("NONE");
                }
                sb.append("\n children:");
                if (children != null) {
                    for (IDAddressPair p : children) {
                        if (p == null) continue;
                        sb.append(" ");
                        sb.append(p.getAddress());
                    }
                } else {
                    sb.append(" NONE");
                }
                shellServ.println(sb.toString());
            }
        };
        mcast.addSpanningTreeChangedCallback(callback);
    }

    @Override
    public void interrupt() {
        if (this.mainThread != null && !this.mainThread.equals(Thread.currentThread())) {
            this.mainThread.interrupt();
        }
    }
}

