/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mcastshell.commands;

import java.io.PrintStream;
import java.net.UnknownHostException;
import ow.mcast.Mcast;
import ow.mcast.McastConfiguration;
import ow.messaging.MessagingAddress;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitCommand
implements Command<Mcast> {
    private static final String[] NAMES = new String[]{"init"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "init <host>[:<port>] [<port>]";
    }

    @Override
    public boolean execute(ShellContext<Mcast> context) throws UnknownHostException {
        MessagingAddress contactAddr;
        Mcast mcast = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        McastConfiguration config = mcast.getConfiguration();
        int port = config.getSelfPort();
        if (args.length < 1) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        if ((contactAddr = mcast.joinOverlay(args[0], port)) != null) {
            out.print("contact: " + contactAddr.getHostAddress() + ":" + contactAddr.getPort() + "\r\n");
        } else {
            out.print("joining failed.\r\n");
        }
        out.flush();
        return false;
    }
}

