/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.ipmulticast.Group;
import ow.ipmulticast.IPMulticast;
import ow.ipmulticast.igmpd.IGMPDaemon;
import ow.mcast.Mcast;
import ow.mcast.McastCallback;
import ow.mcast.McastConfiguration;
import ow.mcast.SpanningTreeChangedCallback;
import ow.messaging.MessagingAddress;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.tool.mrouted.ApplicationLevelMulticastRouterConfiguration;
import ow.tool.mrouted.GroupTable;
import ow.tool.mrouted.MulticastGroupObserver;
import ow.tool.mrouted.MulticastTrafficForwarder;
import ow.tool.mrouted.OverlayGroupObserver;

public class ApplicationLevelMulticastRouter
implements Mcast {
    private static Logger logger = Logger.getLogger("mrouted");
    private ApplicationLevelMulticastRouterConfiguration config;
    private IGMPDaemon igmpd;
    private IPMulticast ipmcast;
    private Mcast mcast;
    private DatagramSocket sockForOverlay;
    private int idSizeInByte;
    private GroupTable groupTable;

    ApplicationLevelMulticastRouter(ApplicationLevelMulticastRouterConfiguration config, IGMPDaemon igmpd, IPMulticast ipmcast, Mcast mcast) throws IOException {
        this.config = config;
        this.igmpd = igmpd;
        this.ipmcast = ipmcast;
        this.mcast = mcast;
        int forwarderPort = this.mcast.getConfiguration().getSelfPort() + this.config.getPortDiffFromMcast();
        InetAddress selfInetAddr = null;
        selfInetAddr = this.mcast.getConfiguration().getSelfAddress() != null ? InetAddress.getByName(this.mcast.getConfiguration().getSelfAddress()) : InetAddress.getLocalHost();
        InetSocketAddress selfSockAddr = new InetSocketAddress(selfInetAddr, forwarderPort);
        this.sockForOverlay = new DatagramSocket(selfSockAddr);
        this.idSizeInByte = this.mcast.getRoutingAlgorithmConfiguration().getIDSizeInByte();
        this.groupTable = new GroupTable(this.config, this.idSizeInByte, this.sockForOverlay, ipmcast);
    }

    public void start() throws IOException {
        MulticastGroupObserver mGroupObserver;
        try {
            mGroupObserver = new MulticastGroupObserver(this.config, this.mcast, this.groupTable, this.igmpd, this.ipmcast, this.idSizeInByte);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not instantiate an instance of MulticastGroupObserver.", e);
            throw e;
        }
        MulticastTrafficForwarder mTrafficForwarder = new MulticastTrafficForwarder(this.sockForOverlay, this.config.getDatagramBufferSize(), this.config.getTTLOnOverlay(), this.groupTable, this.idSizeInByte);
        OverlayGroupObserver overlayObserver = new OverlayGroupObserver(this.config, this.groupTable);
        this.igmpd.start(mGroupObserver);
        this.ipmcast.start(mTrafficForwarder);
        this.mcast.addSpanningTreeChangedCallback(overlayObserver);
    }

    public synchronized void stop() {
        if (this.igmpd != null) {
            this.igmpd.stop();
            this.igmpd = null;
        }
        if (this.ipmcast != null) {
            this.ipmcast.stop();
            this.ipmcast = null;
        }
        if (this.mcast != null) {
            this.mcast.stop();
            this.mcast = null;
        }
        if (this.sockForOverlay != null) {
            this.sockForOverlay.close();
            this.sockForOverlay = null;
        }
        this.groupTable = null;
    }

    public synchronized void suspend() {
        if (this.igmpd != null) {
            this.igmpd.suspend();
        }
        if (this.ipmcast != null) {
            this.ipmcast.suspend();
        }
        if (this.mcast != null) {
            this.mcast.suspend();
        }
    }

    public synchronized void resume() {
        if (this.igmpd != null) {
            this.igmpd.resume();
        }
        if (this.ipmcast != null) {
            this.ipmcast.suspend();
        }
        if (this.mcast != null) {
            this.mcast.resume();
        }
    }

    public Group[] getJoinedMulticastGroups() {
        return this.groupTable.getJoinedGroupSet();
    }

    public MessagingAddress joinOverlay(String hostname, int port) throws UnknownHostException {
        return this.mcast.joinOverlay(hostname, port);
    }

    public MessagingAddress joinOverlay(String hostAndPort) throws UnknownHostException {
        return this.mcast.joinOverlay(hostAndPort);
    }

    public void clearRoutingTable() {
        this.mcast.clearRoutingTable();
    }

    public void clearMcastState() {
        this.mcast.clearMcastState();
    }

    public void joinGroup(ID groupID) {
        this.mcast.joinGroup(groupID);
    }

    public boolean leaveGroup(ID groupID) {
        return this.mcast.leaveGroup(groupID);
    }

    public void leaveAllGroups() {
        this.mcast.leaveAllGroups();
    }

    public void addSpanningTreeChangedCallback(SpanningTreeChangedCallback callback) {
        this.mcast.addSpanningTreeChangedCallback(callback);
    }

    public void addMulticastCallback(McastCallback callback) {
        this.mcast.addMulticastCallback(callback);
    }

    public void multicast(ID groupID, Serializable content) {
        this.mcast.multicast(groupID, content);
    }

    public ID[] getJoinedGroups() {
        return this.mcast.getJoinedGroups();
    }

    public ID[] getGroupsWithSpanningTree() {
        return this.mcast.getGroupsWithSpanningTree();
    }

    public IDAddressPair getParent(ID groupID) {
        return this.mcast.getParent(groupID);
    }

    public IDAddressPair[] getChildren(ID groupID) {
        return this.mcast.getChildren(groupID);
    }

    public RoutingService getRoutingService() {
        return this.mcast.getRoutingService();
    }

    public McastConfiguration getConfiguration() {
        return this.mcast.getConfiguration();
    }

    public RoutingAlgorithmConfiguration getRoutingAlgorithmConfiguration() {
        return this.mcast.getRoutingAlgorithmConfiguration();
    }

    public IDAddressPair getSelfIDAddressPair() {
        return this.mcast.getSelfIDAddressPair();
    }

    public MessagingAddress getStatCollectorAddress() {
        return this.mcast.getStatCollectorAddress();
    }

    public void setStatCollectorAddress(String host, int port) throws UnknownHostException {
        this.mcast.setStatCollectorAddress(host, port);
    }

    public String getLastKeyString() {
        return this.mcast.getLastKeyString();
    }

    public RoutingResult getLastRoutingResult() {
        return this.mcast.getLastRoutingResult();
    }

    public String getRoutingTableString() {
        return this.mcast.getRoutingTableString();
    }
}

