/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.mrouted.commands;

import java.io.PrintStream;
import ow.id.ID;
import ow.ipmulticast.Group;
import ow.ipmulticast.Host;
import ow.tool.mrouted.ApplicationLevelMulticastRouter;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsCommand
implements Command<ApplicationLevelMulticastRouter> {
    private static final String[] NAMES = new String[]{"groups"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "groups";
    }

    @Override
    public boolean execute(ShellContext<ApplicationLevelMulticastRouter> context) {
        ApplicationLevelMulticastRouter almRouter = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        Group[] groups = almRouter.getJoinedMulticastGroups();
        StringBuilder sb = new StringBuilder();
        sb.append("groups:");
        if (groups != null) {
            for (Group g : groups) {
                sb.append("\n ");
                sb.append(g.getGroupAddress());
                sb.append("\t");
                sb.append(ID.getHashcodeBasedID(g.getGroupAddress(), almRouter.getRoutingAlgorithmConfiguration().getIDSizeInByte()));
                if (g.numOfHosts() > 0) {
                    sb.append("\n  ");
                }
                for (Host h : g.getAllHost()) {
                    sb.append(" ");
                    sb.append(h.getAddress());
                }
            }
        }
        sb.append("\n");
        out.print(sb.toString());
        out.flush();
        return false;
    }
}

