/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen.commands;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Random;
import ow.tool.scenariogen.ScenarioGeneratorContext;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutCommand
implements Command<ScenarioGeneratorContext> {
    private static final String[] NAMES = new String[]{"put"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "put <start time> <interval> <# of puts> [<ttl>]";
    }

    @Override
    public boolean execute(ShellContext<ScenarioGeneratorContext> context) {
        ScenarioGeneratorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 3) {
            out.println("Usage: " + this.getHelp());
            return false;
        }
        long startTime = (long)(Double.parseDouble(args[0]) * 1000.0);
        long interval = (long)(Double.parseDouble(args[1]) * 1000.0);
        int repeat = Integer.parseInt(args[2]);
        int ttl = 604800;
        if (args.length >= 4) {
            ttl = Integer.parseInt(args[3]);
        }
        PrintWriter writer = cxt.getWriter();
        Random rnd = new Random(System.currentTimeMillis());
        int numNodes = cxt.getNumberOfNodes();
        long time = startTime;
        for (int i = 0; i < repeat; ++i) {
            writer.print("schedule ");
            writer.print(time);
            writer.print(" control ");
            writer.print(rnd.nextInt(numNodes) + 1);
            writer.print(" put key");
            writer.print(i);
            writer.print(" value");
            writer.print(i);
            writer.print(" ");
            writer.print(ttl);
            writer.println();
            time += interval;
        }
        writer.flush();
        out.println("finish at " + (double)time / 1000.0);
        return false;
    }
}

