package jp.ac.naka.ec.entity.test;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.UnknownHostException;

import javax.sdp.SdpException;
import javax.sdp.SessionDescription;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.AudioPlayer;
import jp.ac.naka.ec.media.MediaListener;
import jp.ac.naka.ec.media.MediaReceiveEvent;
import jp.ac.naka.ec.media.MediaReceiver;

public class AudioReceiverEntity extends AbstractEntity {
	Entity callee;
	AudioPlayer ap;
	ButtonFrame button;
	@Override
	public void init() {
		int port = 22224;
		setEntityType(EntityType.MEDIA_RECEIVER);
		addKeyword("audio_receiver");
		ap = new AudioPlayer(port);
		button = new ButtonFrame("Audio Receiver");
	}

	@Override
	public void receiveMessage(EntityEvent e) {
	}

	@Override
	public void receiveAnswer(EntityEvent evt) {
		SessionDescription sdp = evt.getSessionDescription();
		try {
			System.out.println("start");
			ap.receiveMediaStream(sdp);
			Component comp = ap.getReceiverController();
			button.add(comp);
			button.pack();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void requestMedia() {
		if (callee != null)
			return;
		EntityContainer con = getContainer();
		Entity[] set = null;
		SessionDescription sdp = null;
		set = con.searchEntities("audio_transmitter");
		try {
			sdp = ap.getRequestSessionDescription(this);
		} catch (UnknownHostException e) {
			e.printStackTrace();
		} catch (SdpException e) {
			e.printStackTrace();
		}
		for (Entity entity : set) {
			// TransmitterTăjLXg
			if (entity.getEntityType() == EntityType.MEDIA_TRANSMITTER) {
				sendOffer(sdp, entity);
				callee = entity;
				break;
			}
		}
	}

	@Override
	public void receiveBye(EntityEvent e) {
		if (ap.isPlaying())
			ap.stopReceivingMediaStream();
		callee = null;
	}

	private class ButtonFrame extends JFrame {
		JButton jb = new JButton("Request Media!");
		JButton bye = new JButton("BYE");

		JPanel panel = new JPanel();
		public ButtonFrame(String name) {
			super(name);
			panel.add(jb);
			panel.add(bye);
			setLayout(new GridLayout(2, 1));
			jb.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					requestMedia();
				}

			});

			bye.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (callee != null) {
						sendBye(callee);
						ap.stopReceivingMediaStream();
						callee = null;
						System.out.println("end");
					}
				}
			});
			add(panel, 0);
			pack();
			this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			setVisible(true);
		}
	}

	
	public static void main(String[] args) {
		EntityCollaborator ec = EntityCollaborator.getInstance();
		try {
			ec.initiateSipCore();
			ec.addEntity(new AudioReceiverEntity());
			ec.findPeer();
		} catch (Exception e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
	}

}
