/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity.test;

import javax.sdp.SessionDescription;
import javax.swing.JTextArea;

import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.MediaTransmitter;

/**
 * NGXg󂯂āArfI\[X̃Xg[~OsEntityB|[g44444B
 * @author Takashi Kasuya
 * 
 */
public class VideoTransmitterEntity extends AbstractEntity {
	MediaTransmitter vt;



	Entity caller;

	@Override
	public void init() {
		int port = 44444;
		//setName("MediaTransmitter");
		setEntityType(EntityType.MEDIA_TRANSMITTER);
		addKeyword("camera");
		vt = new MediaTransmitter();
		vt.setVideoPort(port);
		vt.enableAudio(false);
	}

	@Override
	public void receiveMessage(EntityEvent e) {
	}

	@Override
	public SessionDescription receiveOffer(
			EntityEvent evt) {
		if (caller != null)
			return null;
		caller = (Entity)evt.getSource();
		SessionDescription sdp = evt.getSessionDescription();
		SessionDescription temp = null;
		try {
			temp = vt.getResponseSessionDescription(sdp);
			if (!vt.isPlaying())
				vt.sendMedia(sdp);
		} catch (Exception e) {
			e.printStackTrace();
		} 
		return temp;
	}
	
	@Override
	public void receiveBye(EntityEvent e) {
		if (vt.isPlaying())
			vt.close();
		caller = null;
	}
}
